/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.service.impl;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.util.IPTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientInfoServiceImpl
implements ClientInfoService {
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final Logger log = LoggerFactory.getLogger(ClientInfoServiceImpl.class);
    private Boolean useProxiesEnabled;
    private ConfigurationService configurationService;
    private IPTable trustedProxies;

    @Autowired(required=true)
    public ClientInfoServiceImpl(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.trustedProxies = this.parseTrustedProxyRanges(configurationService.getArrayProperty("proxies.trusted.ipranges"));
    }

    @Override
    public String getClientIp(HttpServletRequest request) {
        return this.getClientIp(request.getRemoteAddr(), request.getHeader(X_FORWARDED_FOR_HEADER));
    }

    @Override
    public String getClientIp(String remoteIp, String xForwardedForHeaderValue) {
        String ip = remoteIp;
        if (this.isUseProxiesEnabled()) {
            String xForwardedForIp = this.getXForwardedForIpValue(remoteIp, xForwardedForHeaderValue);
            if (StringUtils.isNotBlank((CharSequence)xForwardedForIp) && this.isRequestFromTrustedProxy(ip)) {
                ip = xForwardedForIp;
            }
        } else if (StringUtils.isNotBlank((CharSequence)xForwardedForHeaderValue)) {
            log.warn("X-Forwarded-For header detected but useProxiesEnabled is not enabled. If your dspace is behind a proxy set it to true");
        }
        return ip;
    }

    @Override
    public boolean isUseProxiesEnabled() {
        if (this.useProxiesEnabled == null) {
            this.useProxiesEnabled = this.configurationService.getBooleanProperty("useProxies", true);
            log.info("useProxies=" + this.useProxiesEnabled);
        }
        return this.useProxiesEnabled;
    }

    private IPTable parseTrustedProxyRanges(String[] proxyProperty) {
        if (ArrayUtils.isEmpty((Object[])proxyProperty)) {
            return null;
        }
        IPTable ipTable = new IPTable();
        try {
            for (String proxyRange : proxyProperty) {
                ipTable.add(proxyRange);
            }
        }
        catch (IPTable.IPFormatException e) {
            log.error("Property proxies.trusted.ipranges contains an invalid IP range", (Throwable)e);
            ipTable = null;
        }
        return ipTable;
    }

    private boolean isRequestFromTrustedProxy(String ipAddress) {
        try {
            return this.trustedProxies == null || this.trustedProxies.contains(ipAddress);
        }
        catch (IPTable.IPFormatException e) {
            log.error("Request contains invalid remote address", (Throwable)e);
            return false;
        }
    }

    private String getXForwardedForIpValue(String remoteIp, String xForwardedForValue) {
        String ip = null;
        String headerValue = StringUtils.trimToEmpty((String)xForwardedForValue);
        for (String xfip : headerValue.split(",")) {
            if (StringUtils.equals((CharSequence)remoteIp, (CharSequence)xfip) || !StringUtils.isNotBlank((CharSequence)xfip) || this.trustedProxies != null && this.isRequestFromTrustedProxy(xfip)) continue;
            ip = xfip.trim();
        }
        return ip;
    }
}

