/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.AbstractModifier;
import gr.ekt.bte.core.MutableRecord;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.springframework.beans.factory.InitializingBean;

public class LanguageCodeModifier
extends AbstractModifier
implements InitializingBean {
    protected static Map<String, String> lang3to2 = null;

    public void afterPropertiesSet() throws Exception {
        lang3to2 = new HashMap<String, String>();
        for (Locale locale : Locale.getAvailableLocales()) {
            try {
                lang3to2.put(locale.getISO3Language(), locale.getLanguage());
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
    }

    public LanguageCodeModifier() {
        super("LanguageCodeModifier");
    }

    public Record modify(MutableRecord rec) {
        List old_values = rec.getValues("language");
        if (old_values == null || old_values.size() == 0) {
            return rec;
        }
        ArrayList<StringValue> new_values = new ArrayList<StringValue>();
        for (Value value : old_values) {
            String lang3 = value.getAsString();
            String lang2 = lang3.length() == 3 ? this.getLang2(lang3) : lang3;
            new_values.add(new StringValue(lang2));
        }
        rec.updateField("language", new_values);
        return rec;
    }

    protected String getLang2(String lang3) {
        return lang3to2.containsKey(lang3) ? lang3to2.get(lang3) : "other";
    }
}

