/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ReviewAction
extends ProcessingAction {
    public static final int MAIN_PAGE = 0;
    public static final int REJECT_PAGE = 1;
    private static final String SUBMIT_APPROVE = "submit_approve";
    private static final String SUBMIT_REJECT = "submit_reject";

    @Override
    public void activate(Context c, XmlWorkflowItem wfItem) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        if (request.getParameter(SUBMIT_APPROVE) != null) {
            return this.processAccept(c, wfi, step, request);
        }
        if (request.getParameter(SUBMIT_REJECT) != null) {
            return this.processRejectPage(c, wfi, step, request);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(SUBMIT_APPROVE);
        options.add(SUBMIT_REJECT);
        return options;
    }

    public ActionResult processAccept(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException {
        this.addApprovedProvenance(c, wfi);
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    private void addApprovedProvenance(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        String now = DCDate.getCurrent().toString();
        String usersName = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().getEPersonName(c.getCurrentUser());
        String provDescription = this.getProvenanceStartId() + " Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        this.itemService.addMetadata(c, wfi.getItem(), MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        this.itemService.update(c, wfi.getItem());
    }

    public ActionResult processRejectPage(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        String reason = request.getParameter("reason");
        if (reason == null || 0 == reason.trim().length()) {
            request.setAttribute("page", (Object)1);
            this.addErrorField(request, "reason");
            return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
        }
        XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), reason);
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }
}

