/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import com.google.common.collect.Iterators;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;

public class MetadataExport {
    protected Iterator<Item> toExport;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected Context context;
    protected boolean exportAll;

    protected MetadataExport() {
    }

    public MetadataExport(Context c, Iterator<Item> toExport, boolean exportAll) {
        this.toExport = toExport;
        this.exportAll = exportAll;
        this.context = c;
    }

    public MetadataExport(Context c, Community toExport, boolean exportAll) {
        try {
            this.toExport = this.buildFromCommunity(c, toExport, 0);
            this.exportAll = exportAll;
            this.context = c;
        }
        catch (SQLException sqle) {
            System.err.println("Error running exporter:");
            sqle.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected Iterator<Item> buildFromCommunity(Context context, Community community, int indent) throws SQLException {
        List<Collection> collections = community.getCollections();
        Iterator<Item> result = null;
        for (Collection collection : collections) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            Iterator<Item> items = this.itemService.findByCollection(context, collection);
            result = this.addItemsToResult(result, items);
        }
        List<Community> communities = community.getSubcommunities();
        for (Community subCommunity : communities) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            Iterator<Item> items = this.buildFromCommunity(context, subCommunity, indent + 1);
            result = this.addItemsToResult(result, items);
        }
        return result;
    }

    private Iterator<Item> addItemsToResult(Iterator<Item> result, Iterator<Item> items) {
        result = result == null ? items : Iterators.concat(result, items);
        return result;
    }

    public DSpaceCSV export() {
        try {
            Context.Mode originalMode = this.context.getCurrentMode();
            this.context.setMode(Context.Mode.READ_ONLY);
            DSpaceCSV csv = new DSpaceCSV(this.exportAll);
            while (this.toExport.hasNext()) {
                Item item = this.toExport.next();
                csv.addItem(item);
                this.context.uncacheEntity(item);
            }
            this.context.setMode(originalMode);
            return csv;
        }
        catch (Exception e) {
            System.err.println("Error exporting to CSV:");
            e.printStackTrace();
            return null;
        }
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("MetadataExport\n", options);
        System.out.println("\nfull export: metadataexport -f filename");
        System.out.println("partial export: metadataexport -i handle -f filename");
        System.exit(exitCode);
    }

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "id", true, "ID or handle of thing to export (item, collection, or community)");
        options.addOption("f", "file", true, "destination where you want file written");
        options.addOption("a", "all", false, "include all metadata fields that are not normally changed (e.g. provenance)");
        options.addOption("h", "help", false, "help");
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (ParseException pe) {
            System.err.println("Error with commands.");
            MetadataExport.printHelp(options, 1);
            System.exit(0);
        }
        if (line.hasOption('h')) {
            MetadataExport.printHelp(options, 0);
        }
        if (!line.hasOption('f')) {
            System.err.println("Required parameter -f missing!");
            MetadataExport.printHelp(options, 1);
        }
        String filename = line.getOptionValue('f');
        Context c = new Context(Context.Mode.READ_ONLY);
        c.turnOffAuthorisationSystem();
        Iterator<Item> toExport = null;
        MetadataExport exporter = null;
        boolean exportAll = line.hasOption('a');
        ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();
        ItemService itemService = contentServiceFactory.getItemService();
        if (!line.hasOption('i')) {
            System.out.println("Exporting whole repository WARNING: May take some time!");
            exporter = new MetadataExport(c, itemService.findAll(c), exportAll);
        } else {
            String handle = line.getOptionValue('i');
            DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(c, handle);
            if (dso == null) {
                System.err.println("Item '" + handle + "' does not resolve to an item in your repository!");
                MetadataExport.printHelp(options, 1);
            }
            if (dso.getType() == 2) {
                System.out.println("Exporting item '" + dso.getName() + "' (" + handle + ")");
                ArrayList<Item> item = new ArrayList<Item>();
                item.add((Item)dso);
                exporter = new MetadataExport(c, item.iterator(), exportAll);
            } else if (dso.getType() == 3) {
                System.out.println("Exporting collection '" + dso.getName() + "' (" + handle + ")");
                Collection collection = (Collection)dso;
                toExport = itemService.findByCollection(c, collection);
                exporter = new MetadataExport(c, toExport, exportAll);
            } else if (dso.getType() == 4) {
                System.out.println("Exporting community '" + dso.getName() + "' (" + handle + ")");
                exporter = new MetadataExport(c, (Community)dso, exportAll);
            } else {
                System.err.println("Error identifying '" + handle + "'");
                System.exit(1);
            }
        }
        DSpaceCSV csv = exporter.export();
        csv.save(filename);
        c.restoreAuthSystemState();
        c.complete();
    }
}

