/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;

public class DiscoverQuery {
    private String query;
    private List<String> filterQueries = new ArrayList<String>();
    private String DSpaceObjectFilter = null;
    private List<String> fieldPresentQueries = new ArrayList<String>();
    private boolean spellCheck;
    private int start = 0;
    private int maxResults = -1;
    private String sortField;
    private SORT_ORDER sortOrder;
    private List<DiscoverFacetField> facetFields = new ArrayList<DiscoverFacetField>();
    private List<String> facetQueries = new ArrayList<String>();
    private int facetLimit = -1;
    private int facetMinCount = -1;
    private int facetOffset = 0;
    private Map<String, DiscoverHitHighlightingField> hitHighlighting;
    private List<String> searchFields = new ArrayList<String>();
    private Map<String, List<String>> properties;
    private String discoveryConfigurationName;

    public DiscoverQuery() {
        this.hitHighlighting = new HashMap<String, DiscoverHitHighlightingField>();
        this.properties = new LinkedHashMap<String, List<String>>();
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setSortField(String sortField, SORT_ORDER sortOrder) {
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    public String getSortField() {
        return this.sortField;
    }

    public SORT_ORDER getSortOrder() {
        return this.sortOrder;
    }

    public void setDSpaceObjectFilter(String DSpaceObjectFilter) {
        this.DSpaceObjectFilter = DSpaceObjectFilter;
    }

    public String getDSpaceObjectFilter() {
        return this.DSpaceObjectFilter;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void addFilterQueries(String ... filterQueries) {
        this.filterQueries.addAll(Arrays.asList(filterQueries));
    }

    public List<String> getFilterQueries() {
        return this.filterQueries;
    }

    public void addFieldPresentQueries(String ... fieldPresentQueries) {
        this.fieldPresentQueries.addAll(Arrays.asList(fieldPresentQueries));
    }

    public List<String> getFieldPresentQueries() {
        return this.fieldPresentQueries;
    }

    public void addFacetQuery(String facetQuery) {
        this.facetQueries.add(facetQuery);
    }

    public List<String> getFacetQueries() {
        return this.facetQueries;
    }

    public void addFacetField(DiscoverFacetField facetField) {
        this.facetFields.add(facetField);
    }

    public List<DiscoverFacetField> getFacetFields() {
        return this.facetFields;
    }

    public int getFacetMinCount() {
        return this.facetMinCount;
    }

    public void setFacetMinCount(int facetMinCount) {
        this.facetMinCount = facetMinCount;
    }

    public int getFacetOffset() {
        return this.facetOffset;
    }

    public void setFacetOffset(int facetOffset) {
        this.facetOffset = facetOffset;
    }

    public void addSearchField(String field) {
        this.searchFields.add(field);
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public Map<String, List<String>> getProperties() {
        return this.properties;
    }

    public void addProperty(String property, String value) {
        List<String> toAddList = this.properties.get(property);
        if (toAddList == null) {
            toAddList = new ArrayList<String>();
        }
        toAddList.add(value);
        this.properties.put(property, toAddList);
    }

    public DiscoverHitHighlightingField getHitHighlightingField(String field) {
        return this.hitHighlighting.get(field);
    }

    public List<DiscoverHitHighlightingField> getHitHighlightingFields() {
        return new ArrayList<DiscoverHitHighlightingField>(this.hitHighlighting.values());
    }

    public void addHitHighlightingField(DiscoverHitHighlightingField hitHighlighting) {
        this.hitHighlighting.put(hitHighlighting.getField(), hitHighlighting);
    }

    public boolean isSpellCheck() {
        return this.spellCheck;
    }

    public void setSpellCheck(boolean spellCheck) {
        this.spellCheck = spellCheck;
    }

    public void addYearRangeFacet(DiscoverySearchFilterFacet facet, FacetYearRange facetYearRange) {
        if (facetYearRange.isValid()) {
            int newestYear = facetYearRange.getNewestYear();
            int oldestYear = facetYearRange.getOldestYear();
            String dateFacet = facetYearRange.getDateFacet();
            int gap = facetYearRange.getYearGap();
            int topYear = this.getTopYear(newestYear, gap);
            if (gap == 1) {
                this.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), 10, facet.getSortOrderSidebar()));
            } else {
                List<String> facetQueries = this.buildFacetQueriesWithGap(newestYear, oldestYear, dateFacet, gap, topYear, facet.getFacetLimit());
                for (String facetQuery : CollectionUtils.emptyIfNull(facetQueries)) {
                    this.addFacetQuery(facetQuery);
                }
            }
        }
    }

    private List<String> buildFacetQueriesWithGap(int newestYear, int oldestYear, String dateFacet, int gap, int topYear, int facetLimit) {
        LinkedList<String> facetQueries = new LinkedList<String>();
        for (int year = topYear; year > oldestYear && facetQueries.size() < facetLimit; year -= gap) {
            int bottomYear = year - gap;
            if (bottomYear < oldestYear) {
                bottomYear = oldestYear;
            }
            int currentTop = year;
            currentTop = year == topYear ? newestYear : --currentTop;
            facetQueries.add(dateFacet + ":[" + bottomYear + " TO " + currentTop + "]");
        }
        Collections.reverse(facetQueries);
        return facetQueries;
    }

    private int getTopYear(int newestYear, int gap) {
        return (int)(Math.ceil((float)newestYear / (float)gap) * (double)gap);
    }

    public String getDiscoveryConfigurationName() {
        return this.discoveryConfigurationName;
    }

    public void setDiscoveryConfigurationName(String discoveryConfigurationName) {
        this.discoveryConfigurationName = discoveryConfigurationName;
    }

    public static enum SORT_ORDER {
        desc,
        asc;

    }
}

