/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

public class Groomer {
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateInstance(3);
        }
    };
    private static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    private Groomer() {
    }

    public static void main(String[] argv) throws SQLException {
        String USAGE = "Groomer -verb [option...]";
        OptionGroup verbs = new OptionGroup();
        verbs.setRequired(true);
        verbs.addOption(new Option("h", "help", false, "explain this tool"));
        verbs.addOption(new Option("a", "aging", false, "discover accounts not used recently"));
        verbs.addOption(new Option("u", "unsalted", false, "list accounts with unsalted password hashes"));
        Options options = new Options();
        options.addOptionGroup(verbs);
        options.addOption("b", "last-used-before", true, "date of last login was before this (for example:  " + dateFormat.get().format(Calendar.getInstance().getTime()) + ")");
        options.addOption("d", "delete", false, "delete matching epersons");
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        try {
            command = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            if (!(ex instanceof MissingOptionException)) {
                new HelpFormatter().printHelp("Groomer -verb [option...]", options);
            }
            System.exit(1);
        }
        if (null == command || command.hasOption('h') || command.hasOption('?')) {
            new HelpFormatter().printHelp("Groomer -verb [option...]", options);
            System.exit(0);
        } else if (command.hasOption('a')) {
            Groomer.aging(command);
        } else if (command.hasOption('u')) {
            Groomer.findUnsalted();
        } else {
            System.err.println("Unimplemented verb:  " + verbs.getSelected());
        }
    }

    private static void aging(CommandLine command) throws SQLException {
        if (!command.hasOption('b')) {
            System.err.println("A last login date is required.");
            System.exit(1);
        }
        Date before = null;
        try {
            before = dateFormat.get().parse(command.getOptionValue('b'));
        }
        catch (java.text.ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        boolean delete = command.hasOption('d');
        Context myContext = new Context();
        List<EPerson> epeople = ePersonService.findNotActiveSince(myContext, before);
        myContext.turnOffAuthorisationSystem();
        for (EPerson account : epeople) {
            System.out.print(account.getID());
            System.out.print('\t');
            System.out.print(account.getLastActive());
            System.out.print('\t');
            System.out.print(account.getEmail());
            System.out.print('\t');
            System.out.print(account.getNetid());
            System.out.print('\t');
            System.out.print(account.getFullName());
            System.out.println();
            if (!delete) continue;
            List<String> whyNot = ePersonService.getDeleteConstraints(myContext, account);
            if (!whyNot.isEmpty()) {
                System.out.print("\tCannot be deleted; referenced in");
                for (String table : whyNot) {
                    System.out.print(' ');
                    System.out.print(table);
                }
                System.out.println();
                continue;
            }
            try {
                ePersonService.delete(myContext, account);
            }
            catch (IOException | AuthorizeException ex) {
                System.err.println(ex.getMessage());
            }
        }
        myContext.restoreAuthSystemState();
        myContext.complete();
    }

    private static void findUnsalted() throws SQLException {
        Context myContext = new Context();
        List<EPerson> ePersons = ePersonService.findUnsalted(myContext);
        for (EPerson ePerson : ePersons) {
            System.out.println(ePerson.getEmail());
        }
        myContext.abort();
    }
}

