/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.factory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.rdf.conversion.RDFConverter;
import org.dspace.rdf.factory.RDFFactory;
import org.dspace.rdf.storage.RDFStorage;
import org.dspace.rdf.storage.URIGenerator;
import org.springframework.beans.factory.annotation.Required;

public class RDFFactoryImpl
extends RDFFactory {
    private static final Logger log = LogManager.getLogger(RDFFactoryImpl.class);
    private RDFStorage storage;
    private URIGenerator generator;
    private RDFConverter converter;

    @Required
    public void setStorage(RDFStorage storage) {
        this.storage = storage;
    }

    @Required
    public void setGenerator(URIGenerator generator) {
        if (log.isDebugEnabled()) {
            log.debug("Using '" + generator.getClass().getCanonicalName() + "' as URIGenerator.");
        }
        this.generator = generator;
    }

    @Required
    public void setConverter(RDFConverter converter) {
        this.converter = converter;
    }

    @Override
    public RDFStorage getRDFStorage() {
        return this.storage;
    }

    @Override
    public URIGenerator getURIGenerator() {
        return this.generator;
    }

    @Override
    public RDFConverter getRDFConverter() {
        return this.converter;
    }
}

