/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.dspace.administer.MetadataImporter;
import org.dspace.administer.RegistryImportException;
import org.dspace.administer.RegistryLoader;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DatabaseRegistryUpdater
implements FlywayCallback {
    private static final Logger log = LoggerFactory.getLogger(DatabaseRegistryUpdater.class);

    private void updateRegistries() {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            String base = config.getProperty("dspace.dir") + File.separator + "config" + File.separator + "registries" + File.separator;
            log.info("Updating Bitstream Format Registry based on {}bitstream-formats.xml", (Object)base);
            RegistryLoader.loadBitstreamFormats(context, base + "bitstream-formats.xml");
            log.info("Updating Metadata Registries based on metadata type configs in {}", (Object)base);
            for (String namespaceFile : config.getArrayProperty("registry.metadata.load")) {
                log.info("Reading {}", (Object)namespaceFile);
                MetadataImporter.loadRegistry(base + namespaceFile, true);
            }
            if (WorkflowServiceFactory.getInstance().getWorkflowService() instanceof XmlWorkflowService) {
                String workflowTypes = "workflow-types.xml";
                log.info("Reading {}", (Object)workflowTypes);
                MetadataImporter.loadRegistry(base + workflowTypes, true);
            }
            context.restoreAuthSystemState();
            context.complete();
            log.info("All Bitstream Format Regitry and Metadata Registry updates were completed.");
        }
        catch (IOException | SQLException | ParserConfigurationException | TransformerException | RegistryImportException | AuthorizeException | NonUniqueMetadataException | SAXException e) {
            log.error("Error attempting to update Bitstream Format and/or Metadata Registries", (Throwable)e);
            throw new RuntimeException("Error attempting to update Bitstream Format and/or Metadata Registries", e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public void beforeClean(Connection connection) {
    }

    public void afterClean(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
    }

    public void afterMigrate(Connection connection) {
        this.updateRegistries();
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo migrationInfo) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo migrationInfo) {
    }

    public void beforeValidate(Connection connection) {
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeBaseline(Connection connection) {
    }

    public void afterBaseline(Connection connection) {
    }

    public void beforeRepair(Connection connection) {
    }

    public void afterRepair(Connection connection) {
    }

    public void beforeInfo(Connection connection) {
    }

    public void afterInfo(Connection connection) {
    }
}

