/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.itunes.EntryInformationImpl;
import com.sun.syndication.feed.module.itunes.types.Duration;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.feed.synd.SyndPersonImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Document;

public class SyndicationFeed {
    protected final Logger log = LogManager.getLogger(SyndicationFeed.class);
    public static final String MSG_UNTITLED = "notitle";
    public static final String MSG_LOGO_TITLE = "logo.title";
    public static final String MSG_FEED_TITLE = "feed.title";
    public static final String MSG_FEED_DESCRIPTION = "general-feed.description";
    public static final String MSG_METADATA = "metadata.";
    public static final String MSG_UITYPE = "ui.type";
    public static final String UITYPE_XMLUI = "xmlui";
    public static final String UITYPE_JSPUI = "jspui";
    protected String defaultTitleField = "dc.title";
    protected String defaultAuthorField = "dc.contributor.author";
    protected String defaultDateField = "dc.date.issued";
    private static final String[] defaultDescriptionFields = new String[]{"dc.description.abstract", "dc.description", "dc.title.alternative", "dc.title"};
    protected String defaultExternalMedia = "dc.source.uri";
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected String titleField = this.configurationService.getProperty("webui.feed.item.title", this.defaultTitleField);
    protected String dateField = this.configurationService.getProperty("webui.feed.item.date", this.defaultDateField);
    private static final String[] descriptionFields = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("webui.feed.item.description", defaultDescriptionFields);
    protected String authorField = this.configurationService.getProperty("webui.feed.item.author", this.defaultAuthorField);
    protected String externalSourceField = this.configurationService.getProperty("webui.feed.podcast.sourceuri", this.defaultExternalMedia);
    protected String dcCreatorField = this.configurationService.getProperty("webui.feed.item.dc.creator");
    protected String dcDateField = this.configurationService.getProperty("webui.feed.item.dc.date");
    protected String dcDescriptionField = this.configurationService.getProperty("webui.feed.item.dc.description");
    protected String[] podcastableMIMETypes = this.configurationService.getArrayProperty("webui.feed.podcast.mimetypes", new String[]{"audio/x-mpeg"});
    protected SyndFeed feed = new SyndFeedImpl();
    protected String uiType = null;
    protected HttpServletRequest request = null;
    protected CollectionService collectionService;
    protected CommunityService communityService;
    protected ItemService itemService;
    protected String baseURL = null;

    public SyndicationFeed(String ui) {
        this.uiType = ui;
        ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();
        this.itemService = contentServiceFactory.getItemService();
        this.collectionService = contentServiceFactory.getCollectionService();
        this.communityService = contentServiceFactory.getCommunityService();
    }

    public static String[] getDescriptionSelectors() {
        return (String[])ArrayUtils.clone((Object[])descriptionFields);
    }

    /*
     * WARNING - void declaration
     */
    public void populate(HttpServletRequest request, Context context, IndexableObject dso, List<IndexableObject> items, Map<String, String> labels) {
        String logoURL = null;
        String objectURL = null;
        String defaultTitle = null;
        boolean podcastFeed = false;
        this.request = request;
        if (dso == null) {
            defaultTitle = ConfigurationManager.getProperty("dspace.name");
            this.feed.setDescription(this.localize(labels, MSG_FEED_DESCRIPTION));
            objectURL = this.resolveURL(request, null);
            logoURL = ConfigurationManager.getProperty("webui.feed.logo.url");
        } else {
            Bitstream logo = null;
            if (dso instanceof IndexableCollection) {
                Collection col = (Collection)((IndexableCollection)dso).getIndexedObject();
                defaultTitle = col.getName();
                this.feed.setDescription(this.collectionService.getMetadata(col, "short_description"));
                logo = col.getLogo();
                String cols = ConfigurationManager.getProperty("webui.feed.podcast.collections");
                if (cols != null && cols.length() > 1 && cols.contains(col.getHandle())) {
                    podcastFeed = true;
                }
                objectURL = this.resolveURL(request, col);
            } else if (dso instanceof IndexableCommunity) {
                Community comm = (Community)((IndexableCommunity)dso).getIndexedObject();
                defaultTitle = comm.getName();
                this.feed.setDescription(this.communityService.getMetadata(comm, "short_description"));
                logo = comm.getLogo();
                String comms = ConfigurationManager.getProperty("webui.feed.podcast.communities");
                if (comms != null && comms.length() > 1 && comms.contains(comm.getHandle())) {
                    podcastFeed = true;
                }
                objectURL = this.resolveURL(request, comm);
            }
            if (logo != null) {
                logoURL = this.urlOfBitstream(request, logo);
            }
        }
        this.feed.setTitle(labels.containsKey(MSG_FEED_TITLE) ? this.localize(labels, MSG_FEED_TITLE) : defaultTitle);
        this.feed.setLink(objectURL);
        this.feed.setPublishedDate(new Date());
        this.feed.setUri(objectURL);
        if (logoURL != null) {
            SyndImageImpl image = new SyndImageImpl();
            image.setLink(objectURL);
            if (StringUtils.isNotBlank((CharSequence)this.feed.getTitle())) {
                image.setTitle(this.feed.getTitle());
            } else {
                image.setTitle(this.localize(labels, MSG_LOGO_TITLE));
            }
            image.setUrl(logoURL);
            this.feed.setImage((SyndImage)image);
        }
        if (items != null) {
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (IndexableObject idxObj : items) {
                String subject;
                String extent;
                List<MetadataValue> authors;
                if (!(idxObj instanceof IndexableItem)) continue;
                Item item = (Item)((IndexableItem)idxObj).getIndexedObject();
                boolean hasDate = false;
                SyndEntryImpl entry = new SyndEntryImpl();
                entries.add(entry);
                String entryURL = this.resolveURL(request, item);
                entry.setLink(entryURL);
                entry.setUri(entryURL);
                String title = this.getOneDC(item, this.titleField);
                entry.setTitle(title == null ? this.localize(labels, MSG_UNTITLED) : title);
                String pubDate = this.getOneDC(item, this.dateField);
                if (pubDate != null) {
                    entry.setPublishedDate(new DCDate(pubDate).toDate());
                    hasDate = true;
                }
                entry.setUpdatedDate(item.getLastModified());
                StringBuffer db = new StringBuffer();
                for (String string : descriptionFields) {
                    void var23_35;
                    List<MetadataValue> dcv;
                    boolean isDate;
                    boolean bl = isDate = string.indexOf("(date)") > 0;
                    if (isDate) {
                        String string2 = string.replaceAll("\\(date\\)", "");
                    }
                    if ((dcv = this.itemService.getMetadataByMetadataString(item, (String)var23_35)).size() <= 0) continue;
                    String fieldLabel = labels.get(MSG_METADATA + (String)var23_35);
                    if (fieldLabel != null && fieldLabel.length() > 0) {
                        db.append(fieldLabel).append(": ");
                    }
                    boolean first = true;
                    for (MetadataValue v : dcv) {
                        if (first) {
                            first = false;
                        } else {
                            db.append("; ");
                        }
                        db.append(isDate ? new DCDate(v.getValue()).toString() : v.getValue());
                    }
                    db.append("\n");
                }
                if (db.length() > 0) {
                    SyndContentImpl desc = new SyndContentImpl();
                    desc.setType("text/plain");
                    desc.setValue(db.toString());
                    entry.setDescription((SyndContent)desc);
                }
                if ((authors = this.itemService.getMetadataByMetadataString(item, this.authorField)).size() > 0) {
                    ArrayList<SyndPersonImpl> creators = new ArrayList<SyndPersonImpl>();
                    for (MetadataValue metadataValue : authors) {
                        SyndPersonImpl sp = new SyndPersonImpl();
                        sp.setName(metadataValue.getValue());
                        creators.add(sp);
                    }
                    entry.setAuthors(creators);
                }
                if (this.dcCreatorField != null || this.dcDateField != null || this.dcDescriptionField != null) {
                    List<MetadataValue> v;
                    List<MetadataValue> dcAuthors;
                    DCModuleImpl dc = new DCModuleImpl();
                    if (this.dcCreatorField != null && (dcAuthors = this.itemService.getMetadataByMetadataString(item, this.dcCreatorField)).size() > 0) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (MetadataValue author3 : dcAuthors) {
                            arrayList.add(author3.getValue());
                        }
                        dc.setCreators(arrayList);
                    }
                    if (this.dcDateField != null && !hasDate && (v = this.itemService.getMetadataByMetadataString(item, this.dcDateField)).size() > 0) {
                        dc.setDate(new DCDate(v.get(0).getValue()).toDate());
                    }
                    if (this.dcDescriptionField != null && (v = this.itemService.getMetadataByMetadataString(item, this.dcDescriptionField)).size() > 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (MetadataValue d : v) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append("\n\n");
                            }
                            stringBuffer.append(d.getValue());
                        }
                        dc.setDescription(stringBuffer.toString());
                    }
                    entry.getModules().add(dc);
                }
                if (!podcastFeed) continue;
                ArrayList<SyndEnclosureImpl> enclosures = new ArrayList<SyndEnclosureImpl>();
                try {
                    List<MetadataValue> list;
                    List<Bundle> bunds = this.itemService.getBundles(item, "ORIGINAL");
                    if (bunds.get(0) != null) {
                        List<Bitstream> list2 = bunds.get(0).getBitstreams();
                        for (Bitstream bit : list2) {
                            String mime = bit.getFormat(context).getMIMEType();
                            if (!ArrayUtils.contains((Object[])this.podcastableMIMETypes, (Object)mime)) continue;
                            SyndEnclosureImpl enc = new SyndEnclosureImpl();
                            enc.setType(bit.getFormat(context).getMIMEType());
                            enc.setLength(bit.getSizeBytes());
                            enc.setUrl(this.urlOfBitstream(request, bit));
                            enclosures.add(enc);
                        }
                    }
                    if ((list = this.itemService.getMetadataByMetadataString(item, this.externalSourceField)).size() > 0) {
                        for (MetadataValue anExternalMedia : list) {
                            SyndEnclosureImpl enc = new SyndEnclosureImpl();
                            enc.setType("audio/x-mpeg");
                            enc.setLength(1L);
                            enc.setUrl(anExternalMedia.getValue());
                            enclosures.add(enc);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                entry.setEnclosures(enclosures);
                EntryInformationImpl itunes = new EntryInformationImpl();
                String string = this.getOneDC(item, this.authorField);
                if (string != null && string.length() > 0) {
                    itunes.setAuthor(string);
                }
                itunes.setSubtitle(title == null ? this.localize(labels, MSG_UNTITLED) : title);
                if (db.length() > 0) {
                    itunes.setSummary(db.toString());
                }
                if ((extent = this.getOneDC(item, "dc.format.extent")) != null && extent.length() > 0) {
                    extent = extent.split(" ")[0];
                    Integer duration = Integer.parseInt(extent);
                    itunes.setDuration(new Duration((long)duration.intValue()));
                }
                if ((subject = this.getOneDC(item, "dc.subject")) != null && subject.length() > 0) {
                    String[] subjects = new String[]{subject};
                    itunes.setKeywords(subjects);
                }
                entry.getModules().add(itunes);
            }
            this.feed.setEntries(entries);
        }
    }

    public void setType(String feedType) {
        this.feed.setFeedType(feedType);
        if ("rss_1.0".equals(feedType)) {
            this.feed.setImage(null);
        }
    }

    public Document outputW3CDom() throws FeedException {
        try {
            SyndFeedOutput feedWriter = new SyndFeedOutput();
            return feedWriter.outputW3CDom(this.feed);
        }
        catch (FeedException e) {
            this.log.error((Object)e);
            throw e;
        }
    }

    public String outputString() throws FeedException {
        SyndFeedOutput feedWriter = new SyndFeedOutput();
        return feedWriter.outputString(this.feed);
    }

    public void output(Writer writer) throws FeedException, IOException {
        SyndFeedOutput feedWriter = new SyndFeedOutput();
        feedWriter.output(this.feed, writer);
    }

    public void addModule(Module m) {
        this.feed.getModules().add(m);
    }

    protected static String getDefaultedConfiguration(String key, String dfl) {
        String result = ConfigurationManager.getProperty(key);
        return result == null ? dfl : result;
    }

    protected String urlOfBitstream(HttpServletRequest request, Bitstream logo) {
        String name = logo.getName();
        return this.resolveURL(request, null) + (this.uiType.equalsIgnoreCase(UITYPE_XMLUI) ? "/bitstream/id/" : "/retrieve/") + logo.getID() + "/" + (name == null ? "" : name);
    }

    protected String resolveURL(HttpServletRequest request, DSpaceObject dso) {
        if (dso == null) {
            if (this.baseURL == null) {
                if (request == null) {
                    this.baseURL = ConfigurationManager.getProperty("dspace.ui.url");
                } else {
                    this.baseURL = ConfigurationManager.getProperty("dspace.ui.url");
                    this.baseURL = this.baseURL + request.getContextPath();
                }
            }
            return this.baseURL;
        }
        if (ConfigurationManager.getBooleanProperty("webui.feed.localresolve")) {
            return this.resolveURL(request, null) + "/handle/" + dso.getHandle();
        }
        return HandleServiceFactory.getInstance().getHandleService().getCanonicalForm(dso.getHandle());
    }

    protected String localize(Map<String, String> labels, String s) {
        return labels.containsKey(s) ? labels.get(s) : "Untranslated:" + s;
    }

    protected String getOneDC(Item item, String field) {
        List<MetadataValue> dcv = this.itemService.getMetadataByMetadataString(item, field);
        return dcv.size() > 0 ? dcv.get(0).getValue() : null;
    }
}

