/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.orcid.xml;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.external.provider.orcid.xml.Converter;
import org.orcid.jaxb.model.record_v2.Person;
import org.orcid.jaxb.model.search_v2.Result;
import org.orcid.jaxb.model.search_v2.Search;
import org.xml.sax.SAXException;

public class XMLtoBio
extends Converter<List<Result>> {
    private static Logger log = LogManager.getLogger(XMLtoBio.class);

    @Override
    public List<Result> convert(InputStream xml) {
        List<Object> bios = new ArrayList<Result>();
        try {
            Search search = (Search)this.unmarshall(xml, Search.class);
            bios = search.getResult();
        }
        catch (URISyntaxException | SAXException e) {
            log.error((Object)e);
        }
        return bios;
    }

    public int getNumberOfResultsFromXml(InputStream xml) {
        try {
            Search search = (Search)this.unmarshall(xml, Search.class);
            return search.getNumFound().intValue();
        }
        catch (URISyntaxException | SAXException e) {
            log.error((Object)e);
            return 0;
        }
    }

    public Person convertSinglePerson(InputStream xml) {
        Person person = null;
        try {
            person = (Person)this.unmarshall(xml, Person.class);
            return person;
        }
        catch (URISyntaxException | SAXException e) {
            log.error((Object)e);
            return null;
        }
    }
}

