/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;

public class RepairDump {
    private RepairDump() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long recordCount = 0L;
        long repairCount = 0L;
        Options options = new Options();
        options.addOption("h", "help", false, "Give help on options.");
        options.addOption("v", "verbose", false, "Write extra information to standard error.");
        CommandLine command = null;
        try {
            command = new DefaultParser().parse(options, args);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        if (command.hasOption("h")) {
            RepairDump.giveHelp(options);
            System.exit(0);
        }
        boolean verbose = command.hasOption("v");
        try (InputStreamReader input = new InputStreamReader(System.in, StandardCharsets.UTF_8);
             CSVReader csvReader = new CSVReader((Reader)input);
             OutputStreamWriter output = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
             CSVWriter csvWriter = new CSVWriter((Writer)output);){
            String[] fields = csvReader.readNext();
            int uidIndex = -1;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals("uid")) continue;
                uidIndex = i;
                break;
            }
            if (uidIndex < 0) {
                System.err.println("Error:  input contains no 'uid' column.");
                System.exit(1);
            }
            csvWriter.writeNext(fields);
            while (null != (fields = csvReader.readNext())) {
                ++recordCount;
                if (fields.length < uidIndex + 1) {
                    fields = Arrays.copyOf(fields, uidIndex);
                }
                if (StringUtils.isBlank((CharSequence)fields[uidIndex])) {
                    if (verbose) {
                        System.err.format("Missing 'uid' at record %d%n", recordCount);
                    }
                    fields[uidIndex] = UUID.randomUUID().toString();
                    ++repairCount;
                }
                csvWriter.writeNext(fields);
            }
        }
        catch (IOException ex) {
            try {
                System.err.format("Could not read the export at record %d:  ", recordCount);
                System.err.println(ex.getMessage());
            }
            catch (Throwable throwable) {
                System.err.format("Repaired %d out of %d records.%n", repairCount, recordCount);
                throw throwable;
            }
            System.err.format("Repaired %d out of %d records.%n", repairCount, recordCount);
        }
        System.err.format("Repaired %d out of %d records.%n", repairCount, recordCount);
    }

    private static void giveHelp(Options options) {
        String className = MethodHandles.lookup().lookupClass().getCanonicalName();
        new HelpFormatter().printHelp(className + " [options]", options);
    }
}

