/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;

public class StatisticsImporter {
    private static final Logger log = LogManager.getLogger(StatisticsImporter.class);
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
    };
    protected final SolrLoggerService solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
    private static HttpSolrClient solr;
    private static DatabaseReader geoipLookup;
    private static boolean skipReverseDNS;
    private List<UUID> localItems;
    private List<UUID> localCollections;
    private List<UUID> localCommunities;
    private List<UUID> localBitstreams;
    private final boolean useLocal;
    protected final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public StatisticsImporter(boolean local) {
        this.useLocal = local;
        if (local) {
            try {
                ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();
                System.out.print("Loading local communities... ");
                Context c = new Context();
                List<Community> communities = this.communityService.findAll(c);
                this.localCommunities = new ArrayList<UUID>();
                for (Community community : communities) {
                    this.localCommunities.add(community.getID());
                }
                System.out.println("Found " + this.localCommunities.size());
                System.out.print("Loading local collections... ");
                List<Collection> collections = this.collectionService.findAll(c);
                this.localCollections = new ArrayList<UUID>();
                for (Collection collection : collections) {
                    this.localCollections.add(collection.getID());
                }
                System.out.println("Found " + this.localCollections.size());
                System.out.print("Loading local items... ");
                Iterator<Item> iterator = this.itemService.findAll(c);
                this.localItems = new ArrayList<UUID>();
                while (iterator.hasNext()) {
                    Item i = iterator.next();
                    this.localItems.add(i.getID());
                }
                System.out.println("Found " + this.localItems.size());
                System.out.print("Loading local bitstreams... ");
                List<Bitstream> bitstreams = this.bitstreamService.findAll(c);
                this.localBitstreams = new ArrayList<UUID>();
                for (Bitstream bitstream : bitstreams) {
                    if (bitstream.getName() == null) continue;
                    this.localBitstreams.add(bitstream.getID());
                }
                System.out.println("Found " + this.localBitstreams.size());
            }
            catch (Exception e) {
                System.err.println("Error retrieving items from DSpace database:");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    protected void load(String filename, Context context, boolean verbose) {
        int counter = 0;
        int errors = 0;
        int searchengines = 0;
        try {
            String line;
            BufferedReader input;
            if (null == filename || "-".equals(filename)) {
                input = new BufferedReader(new InputStreamReader(System.in));
                filename = "standard input";
            } else {
                input = new BufferedReader(new FileReader(new File(filename)));
            }
            System.out.println("Processing file: " + filename);
            String continent = "";
            String country = "";
            String countryCode = "";
            double longitude = 0.0;
            double latitude = 0.0;
            String city = "";
            DNSCache<String, String> dnsCache = new DNSCache<String, String>(2500, 0.75f, 2500);
            Random rand = new Random();
            while ((line = input.readLine()) != null) {
                Object data = "";
                ++counter;
                ++errors;
                if (verbose) {
                    System.out.println("Line:" + line);
                }
                String[] parts = line.split(",");
                String action = parts[1];
                Object id = parts[2];
                Date date = dateFormat.get().parse(parts[3]);
                String user = parts[4];
                String ip = parts[5];
                String dns = "";
                if (!skipReverseDNS) {
                    Object fromCache = dnsCache.get(ip);
                    if (fromCache != null) {
                        dns = (String)fromCache;
                    } else {
                        try {
                            dns = DnsLookup.reverseDns(ip);
                            dnsCache.put(ip, dns);
                        }
                        catch (Exception e) {
                            dns = "";
                        }
                    }
                }
                data = (String)data + "ip addr = " + ip;
                data = (String)data + ", dns name = " + dns;
                if (dns.endsWith(".googlebot.com.") || dns.endsWith(".crawl.yahoo.net.") || dns.endsWith(".search.msn.com.")) {
                    if (verbose) {
                        System.out.println((String)data + ", IGNORE (search engine)");
                    }
                    --errors;
                    ++searchengines;
                    continue;
                }
                try {
                    InetAddress ipAddress = InetAddress.getByName(ip);
                    CityResponse cityResponse = geoipLookup.city(ipAddress);
                    city = cityResponse.getCity().getName();
                    country = cityResponse.getCountry().getName();
                    countryCode = cityResponse.getCountry().getIsoCode();
                    longitude = cityResponse.getLocation().getLongitude();
                    latitude = cityResponse.getLocation().getLatitude();
                    if (verbose) {
                        data = (String)data + ", country = " + country;
                        data = (String)data + ", city = " + city;
                        System.out.println((String)data);
                    }
                    try {
                        continent = LocationUtils.getContinentCode(countryCode);
                    }
                    catch (Exception e) {
                        if (!verbose) continue;
                        System.out.println("Unknown country code: " + countryCode);
                        continue;
                    }
                }
                catch (Exception ipAddress) {
                    // empty catch block
                }
                ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();
                DSpaceObjectService<Bitstream> legacySupportService = null;
                if ("view_bitstream".equals(action)) {
                    legacySupportService = contentServiceFactory.getBitstreamService();
                    if (this.useLocal) {
                        id = "" + this.localBitstreams.get(rand.nextInt(this.localBitstreams.size()));
                    }
                } else if ("view_item".equals(action)) {
                    legacySupportService = contentServiceFactory.getItemService();
                    if (this.useLocal) {
                        id = "" + this.localItems.get(rand.nextInt(this.localItems.size()));
                    }
                } else if ("view_collection".equals(action)) {
                    legacySupportService = contentServiceFactory.getCollectionService();
                    if (this.useLocal) {
                        id = "" + this.localCollections.get(rand.nextInt(this.localCollections.size()));
                    }
                } else if ("view_community".equals(action)) {
                    legacySupportService = contentServiceFactory.getCommunityService();
                    if (this.useLocal) {
                        id = "" + this.localCommunities.get(rand.nextInt(this.localCommunities.size()));
                    }
                }
                if (legacySupportService == null) continue;
                Object dso = legacySupportService.findByIdOrLegacyId(context, (String)id);
                if (dso == null) {
                    if (!verbose) continue;
                    System.err.println(" - DSO with ID '" + (String)id + "' is no longer in the system");
                    continue;
                }
                EPerson eperson = EPersonServiceFactory.getInstance().getEPersonService().findByEmail(context, user);
                int epersonId = 0;
                if (eperson != null) {
                    eperson.getID();
                }
                SolrInputDocument sid = new SolrInputDocument(new String[0]);
                sid.addField("ip", (Object)ip);
                sid.addField("type", (Object)((DSpaceObject)dso).getType());
                sid.addField("id", (Object)((DSpaceObject)dso).getID());
                sid.addField("time", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
                sid.addField("continent", (Object)continent);
                sid.addField("country", (Object)country);
                sid.addField("countryCode", (Object)countryCode);
                sid.addField("city", (Object)city);
                sid.addField("latitude", (Object)latitude);
                sid.addField("longitude", (Object)longitude);
                if (epersonId > 0) {
                    sid.addField("epersonid", (Object)epersonId);
                }
                if (dns != null) {
                    sid.addField("dns", (Object)dns.toLowerCase());
                }
                this.solrLoggerService.storeParents(sid, (DSpaceObject)dso);
                solr.add(sid);
                --errors;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        DecimalFormat percentage = new DecimalFormat("##.###");
        int committed = counter - errors - searchengines;
        System.out.println("Processed " + counter + " log lines");
        if (counter > 0) {
            Double committedpercentage = 100.0 * (double)committed / (double)counter;
            System.out.println(" - " + committed + " entries added to solr: " + percentage.format(committedpercentage) + "%");
            Double errorpercentage = 100.0 * (double)errors / (double)counter;
            System.out.println(" - " + errors + " errors: " + percentage.format(errorpercentage) + "%");
            Double sepercentage = 100.0 * (double)searchengines / (double)counter;
            System.out.println(" - " + searchengines + " search engine activity skipped: " + percentage.format(sepercentage) + "%");
            System.out.print("About to commit data to solr...");
            try {
                solr.commit();
            }
            catch (SolrServerException sse) {
                System.err.println("Error committing statistics to solr server!");
                sse.printStackTrace();
                System.exit(1);
            }
            catch (IOException ioe) {
                System.err.println("Error writing to solr server!");
                ioe.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println(" done!");
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("StatisticsImporter\n", options);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "in", true, "the input file ('-' or omit for standard input)");
        options.addOption("l", "local", false, "developers tool - map external log file to local handles");
        options.addOption("m", "multiple", false, "treat the input file as having a wildcard ending");
        options.addOption("s", "skipdns", false, "skip performing reverse DNS lookups on IP addresses");
        options.addOption("v", "verbose", false, "display verbose output (useful for debugging)");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            StatisticsImporter.printHelp(options, 0);
        }
        if (line.hasOption('s')) {
            skipReverseDNS = true;
        }
        boolean local = line.hasOption('l');
        Context context = new Context();
        boolean verbose = line.hasOption('v');
        String sserver = ConfigurationManager.getProperty("solr-statistics", "server");
        if (verbose) {
            System.out.println("Writing to solr server at: " + sserver);
        }
        solr = new HttpSolrClient.Builder(sserver).build();
        String dbPath = ConfigurationManager.getProperty("usage-statistics", "dbfile");
        try {
            File dbFile = new File(dbPath);
            geoipLookup = new DatabaseReader.Builder(dbFile).build();
        }
        catch (FileNotFoundException fe) {
            log.error("The GeoLite Database file is missing (" + dbPath + ")! Solr Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file.", (Throwable)fe);
        }
        catch (IOException e) {
            log.error("Unable to load GeoLite Database file (" + dbPath + ")! You may need to reinstall it. See the DSpace installation instructions for more details.", (Throwable)e);
        }
        StatisticsImporter si = new StatisticsImporter(local);
        if (line.hasOption('m')) {
            String[] children;
            final File sample = new File(line.getOptionValue('i'));
            File dir = sample.getParentFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(sample.getName());
                }
            };
            for (String in : children = dir.list(filter)) {
                System.out.println(in);
                si.load(dir.getAbsolutePath() + System.getProperty("file.separator") + in, context, verbose);
            }
        } else {
            si.load(line.getOptionValue('i'), context, verbose);
        }
    }

    static {
        skipReverseDNS = false;
    }

    static class DNSCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxCapacity;

        public DNSCache(int initialCapacity, float loadFactor, int maxCapacity) {
            super(initialCapacity, loadFactor, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.maxCapacity;
        }
    }
}

