/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.storage.rdbms.PostgresUtils;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;

public class PostgreSQLCryptoChecker
implements FlywayCallback {
    private Logger log = LogManager.getLogger(PostgreSQLCryptoChecker.class);

    public void checkPgCrypto(Connection connection) {
        String dbType;
        try {
            dbType = DatabaseUtils.getDbType(connection);
        }
        catch (SQLException se) {
            throw new FlywayException("Unable to determine database type.", (Throwable)se);
        }
        if (dbType != null && dbType.equals("postgres") && !PostgresUtils.isPgcryptoUpToDate()) {
            throw new FlywayException("This PostgreSQL Database is INCOMPATIBLE with DSpace. The upgrade will NOT proceed. A supported version (>=" + PostgresUtils.PGCRYPTO_VERSION + ") of the 'pgcrypto' extension must be installed! Please run 'dspace database info' for additional info/tips.");
        }
    }

    public void removePgCrypto(Connection connection) {
        block8: {
            try {
                String schema;
                String dbType = DatabaseUtils.getDbType(connection);
                if (dbType == null || !dbType.equals("postgres") || !PostgresUtils.isPgcryptoInSchema(schema = DatabaseUtils.getSchemaName(connection))) break block8;
                try (Statement statement = connection.createStatement();){
                    statement.execute("DROP EXTENSION pgcrypto CASCADE");
                }
            }
            catch (SQLException e) {
                throw new FlywayException("Failed to check for and/or remove 'pgcrypto' extension", (Throwable)e);
            }
        }
    }

    public void beforeClean(Connection connection) {
        this.removePgCrypto(connection);
    }

    public void afterClean(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
        this.checkPgCrypto(connection);
    }

    public void afterMigrate(Connection connection) {
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo migrationInfo) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo migrationInfo) {
    }

    public void beforeValidate(Connection connection) {
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeBaseline(Connection connection) {
        this.checkPgCrypto(connection);
    }

    public void afterBaseline(Connection connection) {
    }

    public void beforeRepair(Connection connection) {
    }

    public void afterRepair(Connection connection) {
    }

    public void beforeInfo(Connection connection) {
    }

    public void afterInfo(Connection connection) {
    }
}

