/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.utils.DSpace;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class XmlWorkflowFactoryImpl
implements XmlWorkflowFactory {
    public static final String LEGACY_WORKFLOW_NAME = "defaultWorkflow";
    private Logger log = LogManager.getLogger(XmlWorkflowFactoryImpl.class);
    private Map<String, Workflow> workflowMapping;
    @Autowired
    protected CollectionService collectionService;
    @Autowired
    protected HandleService handleService;

    @Override
    public Workflow getWorkflow(Collection collection) throws WorkflowConfigurationException {
        if (this.workflowMapping.get(collection.getHandle()) == null) {
            Workflow defaultWorkflow = this.workflowMapping.get(LEGACY_WORKFLOW_NAME);
            if (defaultWorkflow != null) {
                return defaultWorkflow;
            }
        } else {
            return this.workflowMapping.get(collection.getHandle());
        }
        throw new WorkflowConfigurationException("Error while retrieving workflow for the following collection: " + collection.getHandle());
    }

    @Required
    public void setWorkflowMapping(Map<String, Workflow> workflowMapping) {
        this.workflowMapping = workflowMapping;
    }

    @Override
    public Workflow getWorkflowByName(String workflowName) throws WorkflowConfigurationException {
        for (Workflow workflow : this.workflowMapping.values()) {
            if (!workflow.getID().equals(workflowName)) continue;
            return workflow;
        }
        throw new WorkflowConfigurationException("Error while retrieving workflow by the following name: " + workflowName);
    }

    @Override
    public Workflow getDefaultWorkflow() {
        return this.workflowMapping.get(LEGACY_WORKFLOW_NAME);
    }

    @Override
    public List<Workflow> getAllConfiguredWorkflows() {
        return new ArrayList<Workflow>(this.workflowMapping.values());
    }

    @Override
    public List<Collection> getCollectionHandlesMappedToWorklow(Context context, String workflowName) {
        ArrayList<Collection> collectionsMapped = new ArrayList<Collection>();
        for (String handle : this.workflowMapping.keySet()) {
            if (!this.workflowMapping.get(handle).getID().equals(workflowName)) continue;
            try {
                Collection collection = (Collection)this.handleService.resolveToObject(context, handle);
                if (collection == null) continue;
                collectionsMapped.add(collection);
            }
            catch (SQLException e) {
                this.log.error("SQLException in XmlWorkflowFactoryImpl.getCollectionHandlesMappedToWorklow trying to retrieve collection with handle: " + handle, (Throwable)e);
            }
        }
        return collectionsMapped;
    }

    @Override
    public List<Collection> getAllNonMappedCollectionsHandles(Context context) {
        ArrayList<Collection> nonMappedCollections = new ArrayList<Collection>();
        try {
            for (Collection collection : this.collectionService.findAll(context)) {
                if (this.workflowMapping.get(collection.getHandle()) != null) continue;
                nonMappedCollections.add(collection);
            }
        }
        catch (SQLException e) {
            this.log.error("SQLException in XmlWorkflowFactoryImpl.getAllNonMappedCollectionsHandles trying to retrieve all collections", (Throwable)e);
        }
        return nonMappedCollections;
    }

    @Override
    public boolean workflowByThisNameExists(String workflowName) {
        for (Workflow workflow : this.workflowMapping.values()) {
            if (!workflow.getID().equals(workflowName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultWorkflow(String workflowName) {
        Workflow defaultWorkflow;
        if (StringUtils.isNotBlank((CharSequence)workflowName) && (defaultWorkflow = this.getDefaultWorkflow()) != null && StringUtils.isNotBlank((CharSequence)defaultWorkflow.getID())) {
            return defaultWorkflow.getID().equals(workflowName);
        }
        return false;
    }

    @Override
    public WorkflowActionConfig getActionByName(String workflowActionName) {
        return (WorkflowActionConfig)new DSpace().getServiceManager().getServiceByName(workflowActionName, WorkflowActionConfig.class);
    }

    @Override
    public Step getStepByName(String workflowStepName) {
        return (Step)new DSpace().getServiceManager().getServiceByName(workflowStepName, Step.class);
    }
}

