/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.dspace.app.mediafilter.JPEGFilter;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;

public class BrandedPreviewJPEGFilter
extends MediaFilter {
    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".preview.jpg";
    }

    @Override
    public String getBundleName() {
        return "BRANDED_PREVIEW";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Branded Preview";
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        BufferedImage buf = ImageIO.read(source);
        float xmax = ConfigurationManager.getIntProperty("webui.preview.maxwidth");
        float ymax = ConfigurationManager.getIntProperty("webui.preview.maxheight");
        boolean blurring = ConfigurationManager.getBooleanProperty("webui.preview.blurring");
        boolean hqscaling = ConfigurationManager.getBooleanProperty("webui.preview.hqscaling");
        int brandHeight = ConfigurationManager.getIntProperty("webui.preview.brand.height");
        String brandFont = ConfigurationManager.getProperty("webui.preview.brand.font");
        int brandFontPoint = ConfigurationManager.getIntProperty("webui.preview.brand.fontpoint");
        JPEGFilter jpegFilter = new JPEGFilter();
        return jpegFilter.getThumbDim(currentItem, buf, verbose, xmax, ymax, blurring, hqscaling, brandHeight, brandFontPoint, brandFont);
    }
}

