/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseException;
import org.dspace.browse.SolrBrowseDAO;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class BrowseDAOFactory {
    private BrowseDAOFactory() {
    }

    public static BrowseDAO getInstance(Context context) throws BrowseException {
        String className = ConfigurationManager.getProperty("browseDAO.class");
        if (className == null) {
            return new SolrBrowseDAO(context);
        }
        try {
            return (BrowseDAO)Class.forName(ConfigurationManager.getProperty("browseDAO.class")).getConstructor(Context.class).newInstance(context);
        }
        catch (Exception e) {
            throw new BrowseException("The configuration for browseDAO is invalid: " + className, e);
        }
    }
}

