/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.discovery.indexobject.IndexableClaimedTask;
import org.dspace.discovery.indexobject.IndexableDSpaceObject;
import org.dspace.discovery.indexobject.IndexableInProgressSubmission;
import org.dspace.discovery.indexobject.IndexablePoolTask;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceResourceRestrictionPlugin
implements SolrServiceIndexPlugin,
SolrServiceSearchPlugin {
    private static final Logger log = LogManager.getLogger(SolrServiceResourceRestrictionPlugin.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;

    @Override
    public void additionalIndex(Context context, IndexableObject idxObj, SolrInputDocument document) {
        ReloadableEntity dso = null;
        if (idxObj instanceof IndexableDSpaceObject) {
            dso = ((IndexableDSpaceObject)idxObj).getIndexedObject();
        } else if (idxObj instanceof IndexableInProgressSubmission) {
            ReloadableEntity inProgressSubmission = ((IndexableInProgressSubmission)idxObj).getIndexedObject();
            dso = inProgressSubmission.getItem();
        } else if (idxObj instanceof IndexablePoolTask) {
            PoolTask poolTask = ((IndexablePoolTask)idxObj).getIndexedObject();
            dso = poolTask.getWorkflowItem().getItem();
        } else if (idxObj instanceof IndexableClaimedTask) {
            ClaimedTask claimedTask = ((IndexableClaimedTask)idxObj).getIndexedObject();
            dso = claimedTask.getWorkflowItem().getItem();
        }
        if (dso != null) {
            try {
                List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, (DSpaceObject)dso, 0);
                for (ResourcePolicy resourcePolicy : policies) {
                    String fieldValue = resourcePolicy.getGroup() != null ? "g" + resourcePolicy.getGroup().getID() : "e" + resourcePolicy.getEPerson().getID();
                    document.addField("read", (Object)fieldValue);
                    context.uncacheEntity(resourcePolicy);
                }
                while (dso != null) {
                    if (dso instanceof Community || dso instanceof Collection || dso instanceof Item) {
                        List<ResourcePolicy> policiesAdmin = this.authorizeService.getPoliciesActionFilter(context, (DSpaceObject)dso, 11);
                        for (ResourcePolicy resourcePolicy : policiesAdmin) {
                            String fieldValue = resourcePolicy.getGroup() != null ? "g" + resourcePolicy.getGroup().getID() : "e" + resourcePolicy.getEPerson().getID();
                            document.addField("read", (Object)fieldValue);
                            context.uncacheEntity(resourcePolicy);
                        }
                    }
                    dso = ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getParentObject(context, dso);
                }
            }
            catch (SQLException e) {
                log.error(org.dspace.core.LogManager.getHeader(context, "Error while indexing resource policies", "DSpace object: (id " + ((DSpaceObject)dso).getID() + " type " + ((DSpaceObject)dso).getType() + ")"));
            }
        }
    }

    @Override
    public void additionalSearchParameters(Context context, DiscoverQuery discoveryQuery, SolrQuery solrQuery) {
        try {
            if (!this.authorizeService.isAdmin(context)) {
                StringBuilder resourceQuery = new StringBuilder();
                Group anonymousGroup = this.groupService.findByName(context, "Anonymous");
                String anonGroupId = "";
                if (anonymousGroup != null) {
                    anonGroupId = anonymousGroup.getID().toString();
                }
                resourceQuery.append("read:(g" + anonGroupId);
                EPerson currentUser = context.getCurrentUser();
                if (currentUser != null) {
                    resourceQuery.append(" OR e").append(currentUser.getID());
                }
                Set<Group> groups = this.groupService.allMemberGroupsSet(context, currentUser);
                for (Group group : groups) {
                    resourceQuery.append(" OR g").append(group.getID());
                }
                resourceQuery.append(")");
                if (this.authorizeService.isCommunityAdmin(context) || this.authorizeService.isCollectionAdmin(context)) {
                    resourceQuery.append(" OR ");
                    resourceQuery.append(((SearchService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class)).createLocationQueryForAdministrableItems(context));
                }
                solrQuery.addFilterQuery(new String[]{resourceQuery.toString()});
            }
        }
        catch (SQLException e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while adding resource policy information to query", ""), (Throwable)e);
        }
    }
}

