/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.SiteService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.rdf.RDFMissingIdentifierException;
import org.dspace.rdf.RDFUtil;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class RDFConsumer
implements Consumer {
    private static final Logger log = LogManager.getLogger(RDFConsumer.class);
    protected Deque<DSOIdentifier> toConvert;
    protected Deque<DSOIdentifier> toDelete;
    protected BitstreamService bitstreamService;
    protected BundleService bundleService;
    protected SiteService siteService;
    protected WorkspaceItemService workspaceItemService;
    protected WorkflowItemService workflowItemService;

    @Override
    public void initialize() throws Exception {
        this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        this.bundleService = ContentServiceFactory.getInstance().getBundleService();
        this.siteService = ContentServiceFactory.getInstance().getSiteService();
        this.workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        this.workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();
    }

    @Override
    public void consume(Context ctx, Event event) throws SQLException {
        if (this.toConvert == null) {
            this.toConvert = new LinkedList<DSOIdentifier>();
        }
        if (this.toDelete == null) {
            this.toDelete = new LinkedList<DSOIdentifier>();
        }
        int sType = event.getSubjectType();
        log.debug(event.getEventTypeAsString() + " for " + event.getSubjectTypeAsString() + ":" + event.getSubjectID());
        switch (sType) {
            case 0: {
                this.consumeBitstream(ctx, event);
                return;
            }
            case 1: {
                this.consumeBundles(ctx, event);
                return;
            }
            case 2: {
                this.consumeCommunityCollectionItem(ctx, event);
                return;
            }
            case 3: {
                this.consumeCommunityCollectionItem(ctx, event);
                return;
            }
            case 4: {
                this.consumeCommunityCollectionItem(ctx, event);
                return;
            }
            case 5: {
                this.consumeSite(ctx, event);
                return;
            }
        }
        log.warn("RDFConsumer should not have been given this kind of subject in an event, skipping: " + event.toString());
    }

    public void consumeBitstream(Context ctx, Event event) throws SQLException {
        if (event.getEventType() == 2 || event.getEventType() == 4) {
            Bitstream bitstream = this.bitstreamService.find(ctx, event.getSubjectID());
            if (bitstream == null) {
                log.debug("Cannot find bitstream " + event.getSubjectID() + "! Ignoring, as it is likely it was deleted and we'll cover it by a REMOVE event on its bundle.");
                return;
            }
            List<Bundle> bundles = bitstream.getBundles();
            for (Bundle b : bundles) {
                List<Item> items = b.getItems();
                for (Item i : items) {
                    if (this.workspaceItemService.findByItem(ctx, i) != null || this.workflowItemService.findByItem(ctx, i) != null) {
                        log.debug("Ignoring Item " + i.getID() + " as a corresponding workspace or workflow item exists.");
                        continue;
                    }
                    DSOIdentifier id = new DSOIdentifier(i, ctx);
                    if (this.toDelete.contains(id) || this.toConvert.contains(id)) continue;
                    this.toConvert.addLast(id);
                }
            }
            return;
        }
        if (event.getEventType() == 1 || event.getEventType() == 32) {
            return;
        }
        log.warn("Got an unexpected event type (" + event.getEventTypeAsString() + ") for a bitstream. Ignoring.");
    }

    public void consumeBundles(Context ctx, Event event) throws SQLException {
        if (event.getEventType() == 8 || event.getEventType() == 16 || event.getEventType() == 2 || event.getEventType() == 4) {
            Bundle bundle = (Bundle)this.bundleService.find(ctx, event.getSubjectID());
            if (bundle == null) {
                log.debug("Cannot find bundle " + event.getSubjectID() + "! Ignoring, as it is likely it was deleted and we'll cover it by a REMOVE event on its item.");
                return;
            }
            List<Item> items = bundle.getItems();
            for (Item i : items) {
                if (this.workspaceItemService.findByItem(ctx, i) != null || this.workflowItemService.findByItem(ctx, i) != null) {
                    log.debug("Ignoring Item " + i.getID() + " as a corresponding workspace or workflow item exists.");
                    continue;
                }
                DSOIdentifier id = new DSOIdentifier(i, ctx);
                if (this.toDelete.contains(id) || this.toConvert.contains(id)) continue;
                this.toConvert.addLast(id);
            }
        }
        if (event.getEventType() == 1 || event.getEventType() == 32) {
            return;
        }
        log.warn("Got an unexpected event type (" + event.getEventTypeAsString() + ") for a bundle. Ignoring.");
    }

    public void consumeCommunityCollectionItem(Context ctx, Event event) throws SQLException {
        if (event.getSubjectType() != 4 && event.getSubjectType() != 3 && event.getSubjectType() != 2) {
            log.error("Called on an unexpected Event with subject type " + event.getSubjectTypeAsString() + " and event type " + event.getEventTypeAsString() + ", ignoring.");
            return;
        }
        if (event.getEventType() == 32) {
            DSOIdentifier id = new DSOIdentifier(event.getSubjectType(), event.getSubjectID(), event.getDetail(), event.getIdentifiers());
            if (this.toConvert.contains(id)) {
                this.toConvert.remove(id);
            }
            if (!this.toDelete.contains(id)) {
                this.toDelete.addLast(id);
            }
            return;
        }
        if (event.getEventType() == 2 || event.getEventType() == 4 || event.getEventType() == 8 || event.getEventType() == 16 || event.getEventType() == 1) {
            DSpaceObject dso = event.getSubject(ctx);
            if (dso == null) {
                log.debug("Cannot find " + event.getSubjectTypeAsString() + " " + event.getSubjectID() + "! Ignoring, as it is likely it was deleted and we'll cover it by another event with the type REMOVE.");
                return;
            }
            if (dso instanceof Item && (this.workspaceItemService.findByItem(ctx, (Item)dso) != null || this.workflowItemService.findByItem(ctx, (Item)dso) != null)) {
                log.debug("Ignoring Item " + dso.getID() + " as a corresponding workspace or workflow item exists.");
                return;
            }
            DSOIdentifier id = new DSOIdentifier(dso, ctx);
            if (dso instanceof Item && event.getDetail() != null && event.getDetail().equals("WITHDRAW")) {
                if (this.toConvert.contains(id)) {
                    this.toConvert.remove(id);
                }
                if (!this.toDelete.contains(id)) {
                    this.toDelete.add(id);
                    return;
                }
            }
            if (!this.toDelete.contains(id) && !this.toConvert.contains(id)) {
                this.toConvert.addLast(id);
            }
        }
    }

    public void consumeSite(Context ctx, Event event) throws SQLException {
        if (event.getEventType() == 8 || event.getEventType() == 16 || event.getEventType() == 2 || event.getEventType() == 4) {
            Site site = this.siteService.findSite(ctx);
            DSOIdentifier id = new DSOIdentifier(5, site.getID(), site.getHandle(), Arrays.asList(site.getHandle()));
            if (!this.toConvert.contains(id)) {
                this.toConvert.add(id);
            }
            return;
        }
        log.warn("Got an unexpected Event for the SITE. Event type is " + event.getEventTypeAsString() + ", ignoring.");
    }

    @Override
    public void end(Context ctx) throws Exception {
        DSOIdentifier id;
        log.debug("Started processing of queued events.");
        ctx = new Context(Context.Mode.READ_ONLY);
        if (this.toDelete == null) {
            log.debug("Deletion queue does not exists, creating empty queue.");
            this.toDelete = new LinkedList<DSOIdentifier>();
        }
        if (this.toConvert != null) {
            log.debug("Starting conversion of DSpaceObjects.");
            while (true) {
                try {
                    id = this.toConvert.removeFirst();
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                if (this.toDelete.contains(id)) {
                    log.debug("Skipping " + Constants.typeText[id.type] + " " + id.id.toString() + " as it is marked for deletion as well.");
                    continue;
                }
                log.debug("Converting " + Constants.typeText[id.type] + " " + id.id.toString() + ".");
                this.convert(ctx, id);
            }
            log.debug("Conversion ended.");
        }
        log.debug("Starting to delete data from the triple store...");
        while (true) {
            try {
                id = this.toDelete.removeFirst();
            }
            catch (NoSuchElementException ex) {
                break;
            }
            log.debug("Going to delete data from " + Constants.typeText[id.type] + " " + id.id.toString() + ".");
            this.delete(ctx, id);
        }
        ctx.abort();
        log.debug("Deletion finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convert(Context ctx, DSOIdentifier id) throws SQLException {
        try (Model m = null;){
            if (id.type == 5) {
                m = RDFUtil.convertAndStore(ctx, this.siteService.findSite(ctx));
                return;
            }
            Object dso = ContentServiceFactory.getInstance().getDSpaceObjectService(id.type).find(ctx, id.id);
            if (dso == null) {
                log.error("Cannot find " + Constants.typeText[id.type] + " " + id.id + " unexpectedly! Will delete all information about it in the triple store.");
                this.toDelete.add(id);
                return;
            }
            m = RDFUtil.convertAndStore(ctx, dso);
        }
    }

    void delete(Context context, DSOIdentifier id) throws SQLException {
        try {
            RDFUtil.delete(context, id.type, id.id, id.handle, id.identifiers);
        }
        catch (RDFMissingIdentifierException ex) {
            log.warn("Cannot delete " + Constants.typeText[id.type] + " " + id.id.toString() + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }

    class DSOIdentifier {
        int type;
        UUID id;
        String handle;
        List<String> identifiers;

        DSOIdentifier(int type, UUID id, String handle, List<String> identifiers) {
            this.type = type;
            this.id = id;
            this.handle = handle;
            this.identifiers = identifiers;
        }

        DSOIdentifier(DSpaceObject dso, Context ctx) {
            if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
                throw new IllegalArgumentException(ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso) + " is currently not supported as independent entity by dspace-rdf.");
            }
            this.type = dso.getType();
            this.id = dso.getID();
            this.handle = dso.getHandle();
            this.identifiers = ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getIdentifiers(ctx, dso);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DSOIdentifier)) {
                return false;
            }
            return this.id.equals(((DSOIdentifier)o).id);
        }

        public int hashCode() {
            return this.type + 10 * this.id.hashCode();
        }
    }
}

