/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.util.Calendar;
import java.util.Date;
import org.dspace.statistics.content.DatasetGenerator;

public class DatasetTimeGenerator
extends DatasetGenerator {
    private String type = "time";
    private String dateType;
    private String startDate;
    private String endDate;
    private Date actualStartDate;
    private Date actualEndDate;

    private DatasetTimeGenerator() {
    }

    public void setDateInterval(String dateType, String start, String end) {
        this.startDate = start;
        this.endDate = end;
        this.dateType = dateType;
    }

    public void setDateInterval(String dateType, Date start, Date end) throws IllegalArgumentException {
        this.actualStartDate = start == null ? null : new Date(start.getTime());
        this.actualEndDate = end == null ? null : new Date(end.getTime());
        this.dateType = dateType;
        Calendar startCal1 = Calendar.getInstance();
        Calendar endCal1 = Calendar.getInstance();
        if (startCal1 == null || endCal1 == null) {
            throw new IllegalStateException("Unable to create calendar instances");
        }
        startCal1.setTime(start);
        endCal1.setTime(end);
        if (endCal1.before(startCal1)) {
            throw new IllegalArgumentException();
        }
        int type = -1;
        if ("year".equalsIgnoreCase(dateType)) {
            type = 1;
        } else if ("month".equalsIgnoreCase(dateType)) {
            type = 2;
        } else if ("day".equalsIgnoreCase(dateType)) {
            type = 5;
        } else if ("hour".equalsIgnoreCase(dateType)) {
            type = 10;
        }
        int difStart = this.getTimeDifference(start, Calendar.getInstance().getTime(), type);
        int difEnd = this.getTimeDifference(end, Calendar.getInstance().getTime(), type);
        boolean endPos = false;
        if (difEnd == 0) {
            difEnd = 1;
            endPos = true;
        } else if (0 < difEnd) {
            endPos = true;
        } else {
            ++difEnd;
        }
        this.startDate = "" + difStart;
        this.endDate = (endPos ? "+" : "") + difEnd;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getDateType() {
        return this.dateType.toUpperCase();
    }

    public Date getActualStartDate() {
        return this.actualStartDate == null ? null : new Date(this.actualStartDate.getTime());
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate == null ? null : new Date(actualStartDate.getTime());
    }

    public Date getActualEndDate() {
        return this.actualEndDate == null ? null : new Date(this.actualEndDate.getTime());
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate == null ? null : new Date(actualEndDate.getTime());
    }

    public void setDateType(String dateType) {
        this.dateType = dateType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private int getTimeDifference(Date date1, Date date2, int type) {
        int toAdd;
        int elapsed = 0;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        cal1.clear(14);
        cal2.clear(14);
        cal1.clear(13);
        cal2.clear(13);
        cal1.clear(12);
        cal2.clear(12);
        if (type != 10) {
            cal1.clear(10);
            cal2.clear(10);
            cal1.clear(11);
            cal2.clear(11);
            cal1.set(11, 0);
            cal2.set(11, 0);
        }
        if (type != 5) {
            cal1.set(5, 1);
            cal2.set(5, 1);
        }
        if (type != 2) {
            cal1.clear(2);
            cal2.clear(2);
        }
        if (cal1.after(cal2) || cal1.equals(cal2)) {
            Calendar backup = cal1;
            cal1 = cal2;
            cal2 = backup;
            toAdd = 1;
        } else {
            toAdd = -1;
        }
        while (cal1.before(cal2)) {
            cal1.add(type, 1);
            elapsed += toAdd;
        }
        return elapsed;
    }
}

