/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleMetadataContributor;
import org.dspace.importer.external.service.components.dto.PlainMetadataKeyValueItem;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;

public class EnhancedSimpleMetadataContributor
extends SimpleMetadataContributor {
    private char delimiter = (char)44;
    private char escape = (char)34;

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setEscape(char escape) {
        this.escape = escape;
    }

    public char getEscape() {
        return this.escape;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(PlainMetadataSourceDto t) {
        LinkedList<MetadatumDTO> values = null;
        values = new LinkedList<MetadatumDTO>();
        for (PlainMetadataKeyValueItem metadatum : t.getMetadata()) {
            String[] splitted;
            if (!this.getKey().equals(metadatum.getKey())) continue;
            for (String value : splitted = this.splitToRecord(metadatum.getValue())) {
                MetadatumDTO dcValue = new MetadatumDTO();
                dcValue.setValue(value);
                dcValue.setElement(this.getField().getElement());
                dcValue.setQualifier(this.getField().getQualifier());
                dcValue.setSchema(this.getField().getSchema());
                values.add(dcValue);
            }
        }
        return values;
    }

    private String[] splitToRecord(String value) {
        List rows;
        try (CSVReader csvReader = new CSVReader((Reader)new StringReader(value), this.delimiter, this.escape);){
            rows = csvReader.readAll();
        }
        catch (IOException e) {
            return new String[]{value};
        }
        return (String[])rows.get(0);
    }
}

