/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.params.SolrParams;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrSearchCore {
    private final Logger log = Logger.getLogger(SolrSearchCore.class);
    @Autowired
    protected IndexingService indexingService;
    @Autowired
    protected ConfigurationService configurationService;
    protected SolrClient solr = null;

    public SolrClient getSolr() {
        if (this.solr == null) {
            this.initSolr();
        }
        return this.solr;
    }

    protected void initSolr() {
        if (this.solr == null) {
            UrlValidator urlValidator = new UrlValidator(8L);
            String solrService = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.search.server");
            if (urlValidator.isValid(solrService) || this.configurationService.getBooleanProperty("discovery.solr.url.validation.enabled", true)) {
                try {
                    this.log.debug((Object)("Solr URL: " + solrService));
                    HttpSolrClient solrServer = new HttpSolrClient.Builder(solrService).build();
                    solrServer.setBaseURL(solrService);
                    solrServer.setUseMultiPartPost(true);
                    SolrQuery solrQuery = new SolrQuery().setQuery("search.resourcetype:" + IndexableItem.TYPE + " AND search.resourceid:1");
                    solrQuery.setFields(new String[]{"search.resourcetype", "search.resourceid"});
                    solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
                    DatabaseUtils.checkReindexDiscovery(this.indexingService);
                    this.solr = solrServer;
                }
                catch (IOException | SolrServerException e) {
                    this.log.error((Object)"Error while initializing solr server", e);
                }
            } else {
                this.log.error((Object)("Error while initializing solr, invalid url: " + solrService));
            }
        }
    }
}

