/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.dspace.core.Context;
import org.dspace.discovery.FullTextContentStreams;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.SolrUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class IndexFactoryImpl<T extends IndexableObject, S>
implements IndexFactory<T, S> {
    @Autowired
    protected List<SolrServiceIndexPlugin> solrServiceIndexPlugins;
    @Autowired
    protected SolrSearchCore solrSearchCore;

    @Override
    public SolrInputDocument buildDocument(Context context, T indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("SolrIndexer.lastIndexed", (Object)SolrUtils.getDateFormatter().format(new Date()));
        doc.addField("search.uniqueid", (Object)(indexableObject.getType() + "-" + indexableObject.getID()));
        doc.addField("search.resourcetype", (Object)indexableObject.getType());
        doc.addField("search.resourceid", (Object)indexableObject.getID().toString());
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : ListUtils.emptyIfNull(this.solrServiceIndexPlugins)) {
            solrServiceIndexPlugin.additionalIndex(context, (IndexableObject)indexableObject, doc);
        }
        return doc;
    }

    @Override
    public void writeDocument(Context context, T indexableObject, SolrInputDocument solrInputDocument) throws SQLException, IOException, SolrServerException {
        this.writeDocument(solrInputDocument, null);
    }

    protected void writeDocument(SolrInputDocument doc, FullTextContentStreams streams) throws IOException, SolrServerException {
        SolrClient solr = this.solrSearchCore.getSolr();
        if (solr != null) {
            if (streams != null && !streams.isEmpty()) {
                ContentStreamUpdateRequest req = new ContentStreamUpdateRequest("/update/extract");
                req.addContentStream((ContentStream)streams);
                ModifiableSolrParams params = new ModifiableSolrParams();
                for (String name : doc.getFieldNames()) {
                    for (Object val : doc.getFieldValues(name)) {
                        params.add("literal." + name, new String[]{val.toString()});
                    }
                }
                req.setParams(params);
                req.setParam("uprefix", "attr_");
                req.setParam("fmap.content", "fulltext");
                req.setParam("extractFormat", "text");
                req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                req.process(solr);
            } else {
                solr.add(doc);
            }
        }
    }

    protected void addFacetIndex(SolrInputDocument document, String field, String authority, String fvalue) {
        this.addFacetIndex(document, field, fvalue, authority, fvalue);
    }

    protected void addFacetIndex(SolrInputDocument document, String field, String sortValue, String authority, String fvalue) {
        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
        if (separator == null) {
            separator = "\n|||\n";
        }
        String acvalue = sortValue + separator + fvalue + "###" + authority;
        document.addField(field + "_filter", (Object)acvalue);
        document.addField(field + "_keyword", (Object)fvalue);
        document.addField(field + "_ac", (Object)(fvalue.toLowerCase() + separator + fvalue));
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            document.addField(field + "_acid", (Object)(fvalue.toLowerCase() + separator + fvalue + "###" + authority));
            document.addField(field + "_authority", (Object)authority);
        }
    }

    protected void addNamedResourceTypeIndex(SolrInputDocument document, String filterValue) {
        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
        if (separator == null) {
            separator = "\n|||\n";
        }
        String[] avalues = filterValue.split("###");
        String sortValue = avalues[0];
        String authorityValue = avalues.length == 2 ? avalues[1] : filterValue;
        int idxSeparator = sortValue.indexOf(separator);
        String displayValue = idxSeparator != -1 ? sortValue.substring(idxSeparator + separator.length()) : sortValue;
        this.addFacetIndex(document, "namedresourcetype", sortValue, authorityValue, displayValue);
    }

    @Override
    public void delete(T indexableObject) throws IOException, SolrServerException {
        this.solrSearchCore.getSolr().deleteById(indexableObject.getUniqueIndexID());
    }

    @Override
    public void delete(String indexableObjectIdentifier) throws IOException, SolrServerException {
        this.solrSearchCore.getSolr().deleteById(indexableObjectIdentifier);
    }

    @Override
    public void deleteAll() throws IOException, SolrServerException {
        this.solrSearchCore.getSolr().deleteByQuery("search.resourcetype:" + this.getType());
    }
}

