/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.dspace.app.mediafilter.JPEGFilter;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.SelfRegisterInputFormats;
import org.dspace.content.Item;

public class PDFBoxThumbnail
extends MediaFilter
implements SelfRegisterInputFormats {
    private static Logger log = LogManager.getLogger(PDFBoxThumbnail.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    @Override
    public String getBundleName() {
        return "THUMBNAIL";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Thumbnail";
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        BufferedImage buf;
        try (PDDocument doc = PDDocument.load((InputStream)source);){
            PDFRenderer renderer = new PDFRenderer(doc);
            buf = renderer.renderImage(0);
        }
        catch (InvalidPasswordException ex) {
            log.error("PDF is encrypted. Cannot create thumbnail (item: {})", new Supplier[]{() -> currentItem.getHandle()});
            return null;
        }
        JPEGFilter jpegFilter = new JPEGFilter();
        return jpegFilter.getThumb(currentItem, buf, verbose);
    }

    @Override
    public String[] getInputMIMETypes() {
        return ImageIO.getReaderMIMETypes();
    }

    @Override
    public String[] getInputDescriptions() {
        return null;
    }

    @Override
    public String[] getInputExtensions() {
        return null;
    }
}

