/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.v2.SHERPAPublisher;
import org.dspace.app.sherpa.v2.SHERPASystemMetadata;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SHERPAPublisherResponse {
    private boolean error;
    private String message;
    private SHERPASystemMetadata metadata;
    private List<SHERPAPublisher> publishers;
    private int id;
    private String uri;
    private static Logger log = LogManager.getLogger();

    public SHERPAPublisherResponse(InputStream input, SHERPAFormat format) throws IOException {
        if (format == SHERPAFormat.JSON) {
            this.parseJSON(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseJSON(InputStream jsonData) throws IOException {
        InputStreamReader streamReader = new InputStreamReader(jsonData);
        JSONTokener jsonTokener = new JSONTokener((Reader)streamReader);
        try {
            JSONObject httpResponse = new JSONObject(jsonTokener);
            if (httpResponse.has("items")) {
                JSONArray items = httpResponse.getJSONArray("items");
                if (items.length() > 0) {
                    this.metadata = new SHERPASystemMetadata();
                    this.publishers = new LinkedList<SHERPAPublisher>();
                    for (int itemIndex = 0; itemIndex < items.length(); ++itemIndex) {
                        SHERPAPublisher sherpaPublisher = new SHERPAPublisher();
                        JSONObject item = items.getJSONObject(itemIndex);
                        if (item.has("system_metadata")) {
                            JSONObject systemMetadata = item.getJSONObject("system_metadata");
                            this.metadata = this.parseSystemMetadata(systemMetadata);
                            if (this.metadata.getId() >= 0) {
                                sherpaPublisher.setIdentifier(String.valueOf(this.metadata.getId()));
                            }
                        }
                        sherpaPublisher.setName(this.parsePublisherName(item));
                        sherpaPublisher.setUri(this.parsePublisherURL(item));
                        this.publishers.add(sherpaPublisher);
                    }
                } else {
                    this.error = true;
                    this.message = "No results found";
                }
            } else {
                this.error = true;
                this.message = "No results found";
            }
        }
        catch (JSONException e) {
            log.error("Failed to parse SHERPA response", (Throwable)e);
            this.error = true;
        }
        finally {
            streamReader.close();
        }
    }

    private SHERPASystemMetadata parseSystemMetadata(JSONObject systemMetadata) {
        SHERPASystemMetadata metadata = new SHERPASystemMetadata();
        if (systemMetadata.has("uri")) {
            this.uri = systemMetadata.getString("uri");
            metadata.setUri(this.uri);
        } else {
            log.error("SHERPA URI missing for API response item");
        }
        if (systemMetadata.has("id")) {
            this.id = systemMetadata.getInt("id");
            metadata.setId(this.id);
        } else {
            log.error("SHERPA internal ID missing for API response item");
        }
        if (systemMetadata.has("date_created")) {
            metadata.setDateCreated(systemMetadata.getString("date_created"));
        }
        if (systemMetadata.has("date_modified")) {
            metadata.setDateModified(systemMetadata.getString("date_modified"));
        }
        return metadata;
    }

    private String parsePublisherName(JSONObject publisher) {
        JSONObject publisherName;
        JSONArray publisherNames;
        String name = null;
        if (publisher.has("name") && (publisherNames = publisher.getJSONArray("name")).length() > 0 && (publisherName = publisherNames.getJSONObject(0)).has("name")) {
            name = publisherName.getString("name").trim();
        }
        return name;
    }

    private String parsePublisherURL(JSONObject publisher) {
        if (publisher.has("url")) {
            return publisher.getString("url");
        }
        return null;
    }

    public SHERPAPublisherResponse(String message) {
        this.message = message;
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SHERPASystemMetadata getMetadata() {
        return this.metadata;
    }

    public List<SHERPAPublisher> getPublishers() {
        return this.publishers;
    }

    public static enum SHERPAFormat {
        JSON,
        XML;

    }
}

