/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.springframework.util.CollectionUtils;

public class ContextReadOnlyCache {
    private final HashMap<Triple<String, Integer, String>, Boolean> authorizedActionsCache = new HashMap();
    private final HashMap<Pair<String, String>, Boolean> groupMembershipCache = new HashMap();
    private final HashMap<String, Set<Group>> allMemberGroupsCache = new HashMap();

    public Boolean getCachedAuthorizationResult(DSpaceObject dspaceObject, int action, EPerson eperson) {
        return this.authorizedActionsCache.get(this.buildAuthorizedActionKey(dspaceObject, action, eperson));
    }

    public void cacheAuthorizedAction(DSpaceObject dspaceObject, int action, EPerson eperson, Boolean result) {
        this.authorizedActionsCache.put((Triple<String, Integer, String>)this.buildAuthorizedActionKey(dspaceObject, action, eperson), result);
    }

    public Boolean getCachedGroupMembership(Group group, EPerson eperson) {
        String allMembersGroupKey = this.buildAllMembersGroupKey(eperson);
        if (CollectionUtils.isEmpty((Collection)this.allMemberGroupsCache.get(allMembersGroupKey))) {
            return this.groupMembershipCache.get(this.buildGroupMembershipKey(group, eperson));
        }
        return this.allMemberGroupsCache.get(allMembersGroupKey).contains(group);
    }

    public void cacheGroupMembership(Group group, EPerson eperson, Boolean isMember) {
        if (CollectionUtils.isEmpty((Collection)this.allMemberGroupsCache.get(this.buildAllMembersGroupKey(eperson)))) {
            this.groupMembershipCache.put(this.buildGroupMembershipKey(group, eperson), isMember);
        }
    }

    public void cacheAllMemberGroupsSet(EPerson ePerson, Set<Group> groups) {
        this.allMemberGroupsCache.put(this.buildAllMembersGroupKey(ePerson), groups);
        this.groupMembershipCache.clear();
    }

    public Set<Group> getCachedAllMemberGroupsSet(EPerson ePerson) {
        return this.allMemberGroupsCache.get(this.buildAllMembersGroupKey(ePerson));
    }

    public void clear() {
        this.authorizedActionsCache.clear();
        this.groupMembershipCache.clear();
        this.allMemberGroupsCache.clear();
    }

    private String buildAllMembersGroupKey(EPerson ePerson) {
        return ePerson == null ? "" : ePerson.getID().toString();
    }

    private ImmutableTriple<String, Integer, String> buildAuthorizedActionKey(DSpaceObject dspaceObject, int action, EPerson eperson) {
        return new ImmutableTriple((Object)(dspaceObject == null ? "" : dspaceObject.getID().toString()), (Object)action, (Object)(eperson == null ? "" : eperson.getID().toString()));
    }

    private Pair<String, String> buildGroupMembershipKey(Group group, EPerson eperson) {
        return new ImmutablePair((Object)(group == null ? "" : group.getName()), (Object)(eperson == null ? "" : eperson.getID().toString()));
    }
}

