/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.springframework.beans.factory.annotation.Autowired;

public class SiteServiceInitializer
implements Callback {
    private Logger log = LogManager.getLogger(SiteServiceInitializer.class);
    @Autowired(required=true)
    protected SiteService siteService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private GroupService groupService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSiteObject() {
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            Site site = this.siteService.findSite(context);
            if (site == null) {
                site = this.siteService.createSite(context);
            }
            context.restoreAuthSystemState();
            if (!this.authorizeService.authorizeActionBoolean(context, site, 0)) {
                context.turnOffAuthorisationSystem();
                Group anonGroup = this.groupService.findByName(context, "Anonymous");
                if (anonGroup != null) {
                    this.authorizeService.addPolicy(context, (DSpaceObject)site, 0, anonGroup);
                }
                context.restoreAuthSystemState();
            }
            context.complete();
        }
        catch (Exception e) {
            this.log.error("Error attempting to add/update default Site object", (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public boolean supports(Event event, org.flywaydb.core.api.callback.Context context) {
        return event.equals((Object)Event.AFTER_MIGRATE);
    }

    public boolean canHandleInTransaction(Event event, org.flywaydb.core.api.callback.Context context) {
        return true;
    }

    public void handle(Event event, org.flywaydb.core.api.callback.Context context) {
        this.initializeSiteObject();
    }
}

