/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.bulkedit.BulkEditChange;
import org.dspace.app.bulkedit.BulkEditMetadataValue;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.app.bulkedit.MetadataImportException;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Entity;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.util.UUIDUtils;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class MetadataImport {
    Context c;
    DSpaceCSV csv;
    List<DSpaceCSVLine> toImport;
    protected static Set<String> authorityControlled;
    protected static final String AC_PREFIX = "authority.controlled.";
    protected static final Logger log;
    protected final AuthorityValueService authorityValueService;
    protected final ItemService itemService;
    protected final InstallItemService installItemService;
    protected final CollectionService collectionService;
    protected final HandleService handleService;
    protected final WorkspaceItemService workspaceItemService;
    protected final RelationshipTypeService relationshipTypeService;
    protected final RelationshipService relationshipService;
    protected final EntityTypeService entityTypeService;
    protected final EntityService entityService;

    public MetadataImport(Context c, DSpaceCSV toImport) {
        this.c = c;
        this.csv = toImport;
        this.toImport = toImport.getCSVLines();
        this.installItemService = ContentServiceFactory.getInstance().getInstallItemService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        this.handleService = HandleServiceFactory.getInstance().getHandleService();
        this.authorityValueService = AuthorityServiceFactory.getInstance().getAuthorityValueService();
        this.workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        this.relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
        this.relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        this.entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
        this.entityService = ContentServiceFactory.getInstance().getEntityService();
    }

    public List<BulkEditChange> runImport(boolean change, boolean useWorkflow, boolean workflowNotify, boolean useTemplate) throws MetadataImportException {
        ArrayList<BulkEditChange> changes = new ArrayList<BulkEditChange>();
        try {
            Context.Mode originalMode = this.c.getCurrentMode();
            this.c.setMode(Context.Mode.BATCH_EDIT);
            for (DSpaceCSVLine line : this.toImport) {
                List<String> collections;
                BulkEditChange whatHasChanged;
                UUID id = line.getID();
                if (this.csv.hasActions() && !"".equals(line.getAction()) && id == null) {
                    throw new MetadataImportException("'action' not allowed for new items!");
                }
                WorkspaceItem wsItem = null;
                ReloadableEntity wfItem = null;
                Item item = null;
                if (id != null) {
                    String action;
                    item = (Item)this.itemService.find(this.c, id);
                    if (item == null) {
                        throw new MetadataImportException("Unknown item ID " + id);
                    }
                    whatHasChanged = new BulkEditChange(item);
                    collections = line.get("collection");
                    if (collections != null) {
                        if (collections.size() == 0) {
                            throw new MetadataImportException("Missing collection from item " + item.getHandle());
                        }
                        List<Collection> actualCollections = item.getCollections();
                        this.compare(item, collections, actualCollections, whatHasChanged, change);
                    }
                    for (String md : line.keys()) {
                        if ("id".equals(md)) continue;
                        String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                        if (!MetadataImport.isAuthorityControlledField(md)) {
                            for (int i = 0; i < fromCSV.length; ++i) {
                                int pos = fromCSV[i].indexOf(this.csv.getAuthoritySeparator());
                                if (pos <= -1) continue;
                                fromCSV[i] = fromCSV[i].substring(0, pos);
                            }
                        }
                        this.compare(item, fromCSV, change, md, whatHasChanged, line);
                    }
                    if (this.csv.hasActions() && !"".equals(action = line.getAction())) {
                        if ("expunge".equals(action)) {
                            if (!ConfigurationManager.getBooleanProperty("bulkedit", "allowexpunge", false)) {
                                throw new MetadataImportException("'expunge' action denied by configuration");
                            }
                            if (change) {
                                this.itemService.delete(this.c, item);
                            }
                            whatHasChanged.setDeleted();
                        } else if ("withdraw".equals(action)) {
                            if (!item.isWithdrawn()) {
                                if (change) {
                                    this.itemService.withdraw(this.c, item);
                                }
                                whatHasChanged.setWithdrawn();
                            }
                        } else if ("reinstate".equals(action)) {
                            if (item.isWithdrawn()) {
                                if (change) {
                                    this.itemService.reinstate(this.c, item);
                                }
                                whatHasChanged.setReinstated();
                            }
                        } else {
                            throw new MetadataImportException("Unknown action: " + action);
                        }
                    }
                    if (whatHasChanged.hasChanges()) {
                        changes.add(whatHasChanged);
                    }
                } else {
                    Collection collection;
                    if (this.c.getCurrentUser() == null) {
                        throw new MetadataImportException("When adding new items, a user must be specified with the -e option");
                    }
                    whatHasChanged = new BulkEditChange();
                    for (String md : line.keys()) {
                        if ("id".equals(md)) continue;
                        String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                        if (!MetadataImport.isAuthorityControlledField(md)) {
                            for (int i = 0; i < fromCSV.length; ++i) {
                                int pos = fromCSV[i].indexOf(this.csv.getAuthoritySeparator());
                                if (pos <= -1) continue;
                                fromCSV[i] = fromCSV[i].substring(0, pos);
                            }
                        }
                        this.add(fromCSV, md, whatHasChanged);
                    }
                    collections = line.get("collection");
                    if (collections == null) {
                        throw new MetadataImportException("New items must have a 'collection' assigned in the form of a handle");
                    }
                    ArrayList<Collection> check = new ArrayList<Collection>();
                    for (String handle : collections) {
                        try {
                            collection = (Collection)this.handleService.resolveToObject(this.c, handle);
                            if (collection == null) {
                                throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items");
                            }
                            if (check.contains(collection)) {
                                throw new MetadataImportException("Duplicate collection assignment detected in new item! " + handle);
                            }
                            check.add(collection);
                        }
                        catch (Exception ex) {
                            throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items", ex);
                        }
                    }
                    boolean first = true;
                    for (String handle : collections) {
                        Iterator extra = (Collection)this.handleService.resolveToObject(this.c, handle);
                        if (first) {
                            whatHasChanged.setOwningCollection((Collection)((Object)extra));
                        } else {
                            whatHasChanged.registerNewMappedCollection((Collection)((Object)extra));
                        }
                        first = false;
                    }
                    if (change) {
                        String collectionHandle = line.get("collection").get(0);
                        collection = (Collection)this.handleService.resolveToObject(this.c, collectionHandle);
                        wsItem = this.workspaceItemService.create(this.c, collection, useTemplate);
                        item = wsItem.getItem();
                        LinkedList<BulkEditMetadataValue> relationships = new LinkedList<BulkEditMetadataValue>();
                        for (BulkEditMetadataValue dcv : whatHasChanged.getAdds()) {
                            if (StringUtils.equals((CharSequence)dcv.getSchema(), (CharSequence)MetadataSchemaEnum.RELATION.getName())) {
                                if (!StringUtils.equals((CharSequence)dcv.getElement(), (CharSequence)"type")) {
                                    relationships.add(dcv);
                                    continue;
                                }
                                this.handleRelationshipMetadataValueFromBulkEditMetadataValue(item, dcv);
                                continue;
                            }
                            this.itemService.addMetadata(this.c, item, dcv.getSchema(), dcv.getElement(), dcv.getQualifier(), dcv.getLanguage(), dcv.getValue(), dcv.getAuthority(), dcv.getConfidence());
                        }
                        for (BulkEditMetadataValue relationship : relationships) {
                            this.handleRelationshipMetadataValueFromBulkEditMetadataValue(item, relationship);
                        }
                        if (useWorkflow) {
                            WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
                            wfItem = workflowNotify ? (ReloadableEntity)workflowService.start(this.c, wsItem) : (ReloadableEntity)workflowService.startWithoutNotify(this.c, wsItem);
                        } else {
                            this.installItemService.installItem(this.c, wsItem);
                        }
                        if (line.get("collection").size() > 0) {
                            for (int i = 1; i < collections.size(); ++i) {
                                String handle = collections.get(i);
                                Collection extra = (Collection)this.handleService.resolveToObject(this.c, handle);
                                this.collectionService.addItem(this.c, extra, item);
                            }
                        }
                        whatHasChanged.setItem(item);
                    }
                    changes.add(whatHasChanged);
                }
                if (!change) continue;
                this.c.uncacheEntity(wsItem);
                this.c.uncacheEntity(wfItem);
                this.c.uncacheEntity(item);
            }
            this.c.setMode(originalMode);
        }
        catch (MetadataImportException mie) {
            throw mie;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changes;
    }

    private void handleRelationshipMetadataValueFromBulkEditMetadataValue(Item item, BulkEditMetadataValue dcv) throws SQLException, AuthorizeException {
        LinkedList<String> values = new LinkedList<String>();
        values.add(dcv.getValue());
        LinkedList<String> authorities = new LinkedList<String>();
        authorities.add(dcv.getAuthority());
        LinkedList<Integer> confidences = new LinkedList<Integer>();
        confidences.add(dcv.getConfidence());
        this.handleRelationMetadata(this.c, item, dcv.getSchema(), dcv.getElement(), dcv.getQualifier(), dcv.getLanguage(), values, authorities, confidences);
    }

    protected void compare(Item item, String[] fromCSV, boolean change, String md, BulkEditChange changes, DSpaceCSVLine line) throws SQLException, AuthorizeException {
        String[] dcvalues;
        String all = "";
        for (String part : fromCSV) {
            all = all + part + ",";
        }
        all = all.substring(0, all.length());
        log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all));
        if ("collection".equals(md) || "action".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            String[] bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        AuthorityValue fromAuthority = this.authorityValueService.getAuthorityValueType(md);
        if (md.indexOf(58) > 0) {
            md = md.substring(md.indexOf(58) + 1);
        }
        String[] bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf(91));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf(91));
        }
        log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all + ",looking_for_schema=" + schema + ",looking_for_element=" + element + ",looking_for_qualifier=" + qualifier + ",looking_for_language=" + language));
        if (fromAuthority == null) {
            List<MetadataValue> current = this.itemService.getMetadata(item, schema, element, qualifier, language);
            dcvalues = new String[current.size()];
            int i = 0;
            for (MetadataValue dcv : current) {
                if (dcv.getAuthority() == null || !MetadataImport.isAuthorityControlledField(md)) {
                    dcvalues[i] = dcv.getValue();
                } else {
                    dcvalues[i] = dcv.getValue() + this.csv.getAuthoritySeparator() + dcv.getAuthority();
                    int n = i;
                    dcvalues[n] = dcvalues[n] + this.csv.getAuthoritySeparator() + (dcv.getConfidence() != -1 ? dcv.getConfidence() : 600);
                }
                ++i;
                log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all + ",found=" + dcv.getValue()));
            }
        } else {
            dcvalues = line.get(md).toArray(new String[line.get(md).size()]);
        }
        for (int v = 0; v < fromCSV.length; ++v) {
            String value = fromCSV[v];
            BulkEditMetadataValue dcv = this.getBulkEditValueFromCSV(language, schema, element, qualifier, value, fromAuthority);
            if (fromAuthority != null) {
                fromCSV[v] = value = dcv.getValue() + this.csv.getAuthoritySeparator() + dcv.getAuthority() + this.csv.getAuthoritySeparator() + dcv.getConfidence();
            }
            if (value != null && !"".equals(value) && !this.contains(value, dcvalues)) {
                changes.registerAdd(dcv);
                continue;
            }
            changes.registerConstant(dcv);
        }
        for (String value : dcvalues) {
            BulkEditMetadataValue dcv = new BulkEditMetadataValue();
            dcv.setSchema(schema);
            dcv.setElement(element);
            dcv.setQualifier(qualifier);
            dcv.setLanguage(language);
            if (value == null || !value.contains(this.csv.getAuthoritySeparator())) {
                this.simplyCopyValue(value, dcv);
            } else {
                String[] parts = value.split(this.csv.getAuthoritySeparator());
                dcv.setValue(parts[0]);
                dcv.setAuthority(parts[1]);
                dcv.setConfidence(parts.length > 2 ? Integer.valueOf(parts[2]) : 600);
            }
            if (value == null || "".equals(value) || this.contains(value, fromCSV) || fromAuthority != null) continue;
            log.debug(org.dspace.core.LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all + ",removing_schema=" + schema + ",removing_element=" + element + ",removing_qualifier=" + qualifier + ",removing_language=" + language));
            changes.registerRemove(dcv);
        }
        if (change && (changes.getAdds().size() > 0 || changes.getRemoves().size() > 0)) {
            List<BulkEditMetadataValue> list = changes.getComplete();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> authorities = new ArrayList<String>();
            ArrayList<Integer> confidences = new ArrayList<Integer>();
            for (BulkEditMetadataValue value : list) {
                if (qualifier == null && language == null) {
                    if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || value.getQualifier() != null || value.getLanguage() != null) continue;
                    values.add(value.getValue());
                    authorities.add(value.getAuthority());
                    confidences.add(value.getConfidence());
                    continue;
                }
                if (qualifier == null) {
                    if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || !language.equals(value.getLanguage()) || value.getQualifier() != null) continue;
                    values.add(value.getValue());
                    authorities.add(value.getAuthority());
                    confidences.add(value.getConfidence());
                    continue;
                }
                if (language == null) {
                    if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || !qualifier.equals(value.getQualifier()) || value.getLanguage() != null) continue;
                    values.add(value.getValue());
                    authorities.add(value.getAuthority());
                    confidences.add(value.getConfidence());
                    continue;
                }
                if (!schema.equals(value.getSchema()) || !element.equals(value.getElement()) || !qualifier.equals(value.getQualifier()) || !language.equals(value.getLanguage())) continue;
                values.add(value.getValue());
                authorities.add(value.getAuthority());
                confidences.add(value.getConfidence());
            }
            if (StringUtils.equals((CharSequence)schema, (CharSequence)MetadataSchemaEnum.RELATION.getName())) {
                List<RelationshipType> relationshipTypeList = this.relationshipTypeService.findByLeftOrRightLabel(this.c, element);
                for (RelationshipType relationshipType : relationshipTypeList) {
                    for (Relationship relationship : this.relationshipService.findByItemAndRelationshipType(this.c, item, relationshipType)) {
                        this.relationshipService.delete(this.c, relationship);
                        this.relationshipService.update(this.c, relationship);
                    }
                }
                this.handleRelationMetadata(this.c, item, schema, element, qualifier, language, values, authorities, confidences);
            } else {
                this.itemService.clearMetadata(this.c, item, schema, element, qualifier, language);
                this.itemService.addMetadata(this.c, item, schema, element, qualifier, language, values, authorities, confidences);
                this.itemService.update(this.c, item);
            }
        }
    }

    private void handleRelationMetadata(Context c, Item item, String schema, String element, String qualifier, String language, List<String> values, List<String> authorities, List<Integer> confidences) throws SQLException, AuthorizeException {
        if (StringUtils.equals((CharSequence)element, (CharSequence)"type") && StringUtils.isBlank((CharSequence)qualifier)) {
            this.handleRelationTypeMetadata(c, item, schema, element, qualifier, language, values, authorities, confidences);
        } else {
            for (String value : values) {
                this.handleRelationOtherMetadata(c, item, element, value);
            }
        }
    }

    private void handleRelationOtherMetadata(Context c, Item item, String element, String value) throws SQLException, AuthorizeException {
        Entity entity = this.entityService.findByItemId(c, item.getID());
        boolean left = false;
        LinkedList<RelationshipType> acceptableRelationshipTypes = new LinkedList<RelationshipType>();
        String url = this.handleService.resolveToURL(c, value);
        UUID uuid = UUIDUtils.fromString(value);
        if (uuid == null && StringUtils.isNotBlank((CharSequence)url)) {
            return;
        }
        Entity relationEntity = this.entityService.findByItemId(c, uuid);
        List<RelationshipType> leftRelationshipTypesForEntity = this.entityService.getLeftRelationshipTypes(c, entity);
        List<RelationshipType> rightRelationshipTypesForEntity = this.entityService.getRightRelationshipTypes(c, entity);
        for (RelationshipType relationshipType : this.entityService.getAllRelationshipTypes(c, entity)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)relationshipType.getLeftLabel(), (CharSequence)element)) {
                left = this.handleLeftLabelEqualityRelationshipTypeElement(c, entity, relationEntity, left, acceptableRelationshipTypes, leftRelationshipTypesForEntity, relationshipType);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)relationshipType.getRightLabel(), (CharSequence)element)) continue;
            left = this.handleRightLabelEqualityRelationshipTypeElement(c, entity, relationEntity, left, acceptableRelationshipTypes, rightRelationshipTypesForEntity, relationshipType);
        }
        if (acceptableRelationshipTypes.size() > 1) {
            log.error("Ambiguous relationship_types were found");
            return;
        }
        if (acceptableRelationshipTypes.size() == 0) {
            log.error("no relationship_types were found");
            return;
        }
        this.buildRelationObject(c, item, value, left, (RelationshipType)acceptableRelationshipTypes.get(0));
    }

    private void buildRelationObject(Context c, Item item, String value, boolean left, RelationshipType acceptedRelationshipType) throws SQLException, AuthorizeException {
        Item leftItem = null;
        Item rightItem = null;
        if (left) {
            leftItem = item;
            rightItem = (Item)this.itemService.findByIdOrLegacyId(c, value);
        } else {
            rightItem = item;
            leftItem = (Item)this.itemService.findByIdOrLegacyId(c, value);
        }
        RelationshipType relationshipType = acceptedRelationshipType;
        int leftPlace = this.relationshipService.findLeftPlaceByLeftItem(c, leftItem) + 1;
        int rightPlace = this.relationshipService.findRightPlaceByRightItem(c, rightItem) + 1;
        Relationship persistedRelationship = this.relationshipService.create(c, leftItem, rightItem, relationshipType, leftPlace, rightPlace);
        this.relationshipService.update(c, persistedRelationship);
    }

    private boolean handleRightLabelEqualityRelationshipTypeElement(Context c, Entity entity, Entity relationEntity, boolean left, List<RelationshipType> acceptableRelationshipTypes, List<RelationshipType> rightRelationshipTypesForEntity, RelationshipType relationshipType) throws SQLException {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.entityService.getType(c, entity).getLabel(), (CharSequence)relationshipType.getRightType().getLabel()) && StringUtils.equalsIgnoreCase((CharSequence)this.entityService.getType(c, relationEntity).getLabel(), (CharSequence)relationshipType.getLeftType().getLabel())) {
            for (RelationshipType rightRelationshipType : rightRelationshipTypesForEntity) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)rightRelationshipType.getLeftType().getLabel(), (CharSequence)relationshipType.getLeftType().getLabel()) && !StringUtils.equalsIgnoreCase((CharSequence)rightRelationshipType.getRightType().getLabel(), (CharSequence)relationshipType.getLeftType().getLabel())) continue;
                left = false;
                acceptableRelationshipTypes.add(relationshipType);
            }
        }
        return left;
    }

    private boolean handleLeftLabelEqualityRelationshipTypeElement(Context c, Entity entity, Entity relationEntity, boolean left, List<RelationshipType> acceptableRelationshipTypes, List<RelationshipType> leftRelationshipTypesForEntity, RelationshipType relationshipType) throws SQLException {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.entityService.getType(c, entity).getLabel(), (CharSequence)relationshipType.getLeftType().getLabel()) && StringUtils.equalsIgnoreCase((CharSequence)this.entityService.getType(c, relationEntity).getLabel(), (CharSequence)relationshipType.getRightType().getLabel())) {
            for (RelationshipType leftRelationshipType : leftRelationshipTypesForEntity) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)leftRelationshipType.getRightType().getLabel(), (CharSequence)relationshipType.getRightType().getLabel()) && !StringUtils.equalsIgnoreCase((CharSequence)leftRelationshipType.getLeftType().getLabel(), (CharSequence)relationshipType.getRightType().getLabel())) continue;
                left = true;
                acceptableRelationshipTypes.add(relationshipType);
            }
        }
        return left;
    }

    private void handleRelationTypeMetadata(Context c, Item item, String schema, String element, String qualifier, String language, List<String> values, List<String> authorities, List<Integer> confidences) throws SQLException, AuthorizeException {
        EntityType entityType = this.entityTypeService.findByEntityType(c, values.get(0));
        if (entityType != null) {
            authorities.add(String.valueOf(entityType.getID()));
            this.itemService.clearMetadata(c, item, schema, element, qualifier, language);
            this.itemService.addMetadata(c, item, schema, element, qualifier, language, values, authorities, confidences);
            this.itemService.update(c, item);
        }
    }

    protected void compare(Item item, List<String> collections, List<Collection> actualCollections, BulkEditChange bechange, boolean change) throws SQLException, AuthorizeException, IOException, MetadataImportException {
        boolean found;
        String oldOwner = item.getOwningCollection().getHandle();
        String newOwner = collections.get(0);
        Collection newCollection = (Collection)this.handleService.resolveToObject(this.c, newOwner);
        if (newCollection == null) {
            throw new MetadataImportException("'" + newOwner + "' is not a Collection! You must specify a valid collection ID");
        }
        if (!oldOwner.equals(newOwner)) {
            bechange.changeOwningCollection(item.getOwningCollection(), (Collection)this.handleService.resolveToObject(this.c, newOwner));
        }
        boolean first = true;
        for (String string : collections) {
            if (!first) {
                found = false;
                for (Collection collection : actualCollections) {
                    if (collection.getID() == item.getOwningCollection().getID() || !string.equals(collection.getHandle())) continue;
                    found = true;
                }
                DSpaceObject dso = this.handleService.resolveToObject(this.c, string);
                if (dso == null || dso.getType() != 3) {
                    throw new MetadataImportException("Collection defined for item " + item.getID() + " (" + item.getHandle() + ") is not a collection");
                }
                if (!found) {
                    Collection col = (Collection)dso;
                    bechange.registerNewMappedCollection(col);
                }
            }
            first = false;
        }
        for (Collection collection : actualCollections) {
            found = false;
            first = true;
            for (String csvcollection : collections) {
                if (first && collection.getID().equals(item.getOwningCollection().getID())) {
                    found = true;
                } else if (!first && collection.getHandle().equals(csvcollection)) {
                    found = true;
                }
                first = false;
            }
            if (found) continue;
            bechange.registerOldMappedCollection(collection);
        }
        if (change) {
            for (Collection collection : bechange.getOldMappedCollections()) {
                this.collectionService.removeItem(this.c, collection, item);
            }
            if (bechange.getNewOwningCollection() != null) {
                this.collectionService.addItem(this.c, bechange.getNewOwningCollection(), item);
                item.setOwningCollection(bechange.getNewOwningCollection());
                this.itemService.update(this.c, item);
            }
            if (bechange.getOldOwningCollection() != null) {
                boolean found2 = false;
                for (Collection c : item.getCollections()) {
                    if (!c.getID().equals(bechange.getOldOwningCollection().getID())) continue;
                    found2 = true;
                }
                if (found2) {
                    this.collectionService.removeItem(this.c, bechange.getOldOwningCollection(), item);
                }
            }
            for (Collection collection : bechange.getNewMappedCollections()) {
                this.collectionService.addItem(this.c, collection, item);
            }
        }
    }

    protected void add(String[] fromCSV, String md, BulkEditChange changes) throws SQLException, AuthorizeException {
        if ("collection".equals(md) || "action".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            String[] bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        AuthorityValue fromAuthority = this.authorityValueService.getAuthorityValueType(md);
        if (md.indexOf(58) > 0) {
            md = md.substring(md.indexOf(58) + 1);
        }
        String[] bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf(91));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf(91));
        }
        for (String value : fromCSV) {
            BulkEditMetadataValue dcv = this.getBulkEditValueFromCSV(language, schema, element, qualifier, value, fromAuthority);
            if (fromAuthority != null) {
                value = dcv.getValue() + this.csv.getAuthoritySeparator() + dcv.getAuthority() + this.csv.getAuthoritySeparator() + dcv.getConfidence();
            }
            if (value == null || "".equals(value)) continue;
            changes.registerAdd(dcv);
        }
    }

    protected BulkEditMetadataValue getBulkEditValueFromCSV(String language, String schema, String element, String qualifier, String value, AuthorityValue fromAuthority) {
        BulkEditMetadataValue dcv = new BulkEditMetadataValue();
        dcv.setSchema(schema);
        dcv.setElement(element);
        dcv.setQualifier(qualifier);
        dcv.setLanguage(language);
        if (fromAuthority != null) {
            if (value.indexOf(58) > 0) {
                value = value.substring(0, value.indexOf(58));
            }
            List<AuthorityValue> byValue = this.authorityValueService.findByValue(this.c, schema, element, qualifier, value);
            AuthorityValue authorityValue = null;
            if (byValue.isEmpty()) {
                String toGenerate = fromAuthority.generateString() + value;
                String field = schema + "_" + element + (StringUtils.isNotBlank((CharSequence)qualifier) ? "_" + qualifier : "");
                authorityValue = this.authorityValueService.generate(this.c, toGenerate, value, field);
                dcv.setAuthority(toGenerate);
            } else {
                authorityValue = byValue.get(0);
                dcv.setAuthority(authorityValue.getId());
            }
            dcv.setValue(authorityValue.getValue());
            dcv.setConfidence(600);
        } else if (value == null || !value.contains(this.csv.getAuthoritySeparator())) {
            this.simplyCopyValue(value, dcv);
        } else {
            String[] parts = value.split(this.csv.getEscapedAuthoritySeparator());
            dcv.setValue(parts[0]);
            dcv.setAuthority(parts[1]);
            dcv.setConfidence(parts.length > 2 ? Integer.valueOf(parts[2]) : 600);
        }
        return dcv;
    }

    protected void simplyCopyValue(String value, BulkEditMetadataValue dcv) {
        dcv.setValue(value);
        dcv.setAuthority(null);
        dcv.setConfidence(-1);
    }

    protected boolean contains(String needle, String[] haystack) {
        for (String examine : haystack) {
            if (!this.clean(examine).equals(this.clean(needle))) continue;
            return true;
        }
        return false;
    }

    protected String clean(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("\r\n", "").replaceAll("\n", "").trim();
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("MetatadataImport\n", options);
        System.out.println("\nmetadataimport: MetadataImport -f filename");
        System.exit(exitCode);
    }

    private static int displayChanges(List<BulkEditChange> changes, boolean changed) {
        int changeCounter = 0;
        for (BulkEditChange change : changes) {
            String md;
            String cName;
            String cHandle;
            List<BulkEditMetadataValue> adds = change.getAdds();
            List<BulkEditMetadataValue> removes = change.getRemoves();
            List<Collection> newCollections = change.getNewMappedCollections();
            List<Collection> oldCollections = change.getOldMappedCollections();
            if (adds.size() > 0 || removes.size() > 0 || newCollections.size() > 0 || oldCollections.size() > 0 || change.getNewOwningCollection() != null || change.getOldOwningCollection() != null || change.isDeleted() || change.isWithdrawn() || change.isReinstated()) {
                Item i = change.getItem();
                System.out.println("-----------------------------------------------------------");
                if (!change.isNewItem()) {
                    System.out.println("Changes for item: " + i.getID() + " (" + i.getHandle() + ")");
                } else {
                    System.out.print("New item: ");
                    if (i != null) {
                        if (i.getHandle() != null) {
                            System.out.print(i.getID() + " (" + i.getHandle() + ")");
                        } else {
                            System.out.print(i.getID() + " (in workflow)");
                        }
                    }
                    System.out.println();
                }
                ++changeCounter;
            }
            if (change.isDeleted()) {
                if (changed) {
                    System.out.println(" - EXPUNGED!");
                } else {
                    System.out.println(" - EXPUNGE!");
                }
            }
            if (change.isWithdrawn()) {
                if (changed) {
                    System.out.println(" - WITHDRAWN!");
                } else {
                    System.out.println(" - WITHDRAW!");
                }
            }
            if (change.isReinstated()) {
                if (changed) {
                    System.out.println(" - REINSTATED!");
                } else {
                    System.out.println(" - REINSTATE!");
                }
            }
            if (change.getNewOwningCollection() != null) {
                String cName2;
                String cHandle2;
                Collection c = change.getNewOwningCollection();
                if (c != null) {
                    cHandle2 = c.getHandle();
                    cName2 = c.getName();
                    if (!changed) {
                        System.out.print(" + New owning collection (" + cHandle2 + "): ");
                    } else {
                        System.out.print(" + New owning collection  (" + cHandle2 + "): ");
                    }
                    System.out.println(cName2);
                }
                if ((c = change.getOldOwningCollection()) != null) {
                    cHandle2 = c.getHandle();
                    cName2 = c.getName();
                    if (!changed) {
                        System.out.print(" + Old owning collection (" + cHandle2 + "): ");
                    } else {
                        System.out.print(" + Old owning collection  (" + cHandle2 + "): ");
                    }
                    System.out.println(cName2);
                }
            }
            for (Collection c : newCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Map to collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Mapped to collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (Collection c : oldCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Un-map from collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Un-mapped from collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (BulkEditMetadataValue metadataValue : adds) {
                md = metadataValue.getSchema() + "." + metadataValue.getElement();
                if (metadataValue.getQualifier() != null) {
                    md = md + "." + metadataValue.getQualifier();
                }
                if (metadataValue.getLanguage() != null) {
                    md = md + "[" + metadataValue.getLanguage() + "]";
                }
                if (!changed) {
                    System.out.print(" + Add    (" + md + "): ");
                } else {
                    System.out.print(" + Added   (" + md + "): ");
                }
                System.out.print(metadataValue.getValue());
                if (MetadataImport.isAuthorityControlledField(md)) {
                    System.out.print(", authority = " + metadataValue.getAuthority());
                    System.out.print(", confidence = " + metadataValue.getConfidence());
                }
                System.out.println("");
            }
            for (BulkEditMetadataValue metadataValue : removes) {
                md = metadataValue.getSchema() + "." + metadataValue.getElement();
                if (metadataValue.getQualifier() != null) {
                    md = md + "." + metadataValue.getQualifier();
                }
                if (metadataValue.getLanguage() != null) {
                    md = md + "[" + metadataValue.getLanguage() + "]";
                }
                if (!changed) {
                    System.out.print(" - Remove (" + md + "): ");
                } else {
                    System.out.print(" - Removed (" + md + "): ");
                }
                System.out.print(metadataValue.getValue());
                if (MetadataImport.isAuthorityControlledField(md)) {
                    System.out.print(", authority = " + metadataValue.getAuthority());
                    System.out.print(", confidence = " + metadataValue.getConfidence());
                }
                System.out.println("");
            }
        }
        return changeCounter;
    }

    private static boolean isAuthorityControlledField(String md) {
        String mdf = StringUtils.substringAfter((String)md, (String)":");
        mdf = StringUtils.substringBefore((String)mdf, (String)"[");
        return authorityControlled.contains(mdf);
    }

    private static void setAuthorizedMetadataFields() {
        authorityControlled = new HashSet<String>();
        Enumeration<?> propertyNames = ConfigurationManager.getProperties().propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = ((String)propertyNames.nextElement()).trim();
            if (!key.startsWith(AC_PREFIX) || !ConfigurationManager.getBooleanProperty(key, false)) continue;
            authorityControlled.add(key.substring(AC_PREFIX.length()));
        }
    }

    public static void main(String[] argv) {
        List<BulkEditChange> changes;
        MetadataImport importer;
        boolean change;
        Context c;
        boolean workflowNotify;
        boolean useWorkflow;
        boolean useTemplate;
        block32: {
            DSpaceCSV csv;
            CommandLine line;
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("f", "file", true, "source file");
            options.addOption("e", "email", true, "email address or user id of user (required if adding new items)");
            options.addOption("s", "silent", false, "silent operation - doesn't request confirmation of changes USE WITH CAUTION");
            options.addOption("w", "workflow", false, "workflow - when adding new items, use collection workflow");
            options.addOption("n", "notify", false, "notify - when adding new items using a workflow, send notification emails");
            options.addOption("t", "template", false, "template - when adding new items, use the collection template (if it exists)");
            options.addOption("h", "help", false, "help");
            try {
                line = parser.parse(options, argv);
            }
            catch (ParseException pe) {
                System.err.println("Error parsing command line arguments: " + pe.getMessage());
                System.exit(1);
                return;
            }
            if (line.hasOption('h')) {
                MetadataImport.printHelp(options, 0);
            }
            if (!line.hasOption('f')) {
                System.err.println("Required parameter -f missing!");
                MetadataImport.printHelp(options, 1);
            }
            String filename = line.getOptionValue('f');
            useTemplate = false;
            if (line.hasOption('t')) {
                useTemplate = true;
            }
            useWorkflow = false;
            workflowNotify = false;
            if (line.hasOption('w')) {
                useWorkflow = true;
                if (line.hasOption('n')) {
                    workflowNotify = true;
                }
            } else if (line.hasOption('n')) {
                System.err.println("Invalid option 'n': (notify) can only be specified with the 'w' (workflow) option.");
                System.exit(1);
            }
            try {
                c = new Context();
                c.turnOffAuthorisationSystem();
            }
            catch (Exception e) {
                System.err.println("Unable to create a new DSpace Context: " + e.getMessage());
                System.exit(1);
                return;
            }
            try {
                if (line.hasOption('e')) {
                    String e = line.getOptionValue('e');
                    EPerson eperson = e.indexOf(64) != -1 ? EPersonServiceFactory.getInstance().getEPersonService().findByEmail(c, e) : (EPerson)EPersonServiceFactory.getInstance().getEPersonService().find(c, UUID.fromString(e));
                    if (eperson == null) {
                        System.out.println("Error, eperson cannot be found: " + e);
                        System.exit(1);
                    }
                    c.setCurrentUser(eperson);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to find DSpace user: " + e.getMessage());
                System.exit(1);
                return;
            }
            change = false;
            try {
                csv = new DSpaceCSV(new File(filename), c);
            }
            catch (MetadataImportInvalidHeadingException miihe) {
                System.err.println(miihe.getMessage());
                System.exit(1);
                return;
            }
            catch (Exception e) {
                System.err.println("Error reading file: " + e.getMessage());
                System.exit(1);
                return;
            }
            importer = new MetadataImport(c, csv);
            if (!line.hasOption('s')) {
                try {
                    changes = importer.runImport(false, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                int changeCounter = MetadataImport.displayChanges(changes, false);
                if (changeCounter > 0) {
                    try {
                        System.out.println("\n" + changeCounter + " item(s) will be changed\n");
                        System.out.print("Do you want to make these changes? [y/n] ");
                        String yn = new BufferedReader(new InputStreamReader(System.in)).readLine();
                        if ("y".equalsIgnoreCase(yn)) {
                            change = true;
                            break block32;
                        }
                        System.out.println("No data has been changed.");
                    }
                    catch (IOException ioe) {
                        System.err.println("Error: " + ioe.getMessage());
                        System.err.println("No changes have been made");
                        System.exit(1);
                    }
                } else {
                    System.out.println("There were no changes detected");
                }
            } else {
                change = true;
            }
        }
        try {
            if (change) {
                try {
                    changes = importer.runImport(true, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                MetadataImport.displayChanges(changes, true);
            }
            c.restoreAuthSystemState();
            c.complete();
        }
        catch (Exception e) {
            c.abort();
            System.err.println("Error committing changes to database: " + e.getMessage());
            System.err.println("Aborting most recent changes.");
            System.exit(1);
        }
    }

    static {
        MetadataImport.setAuthorizedMetadataFields();
        log = LogManager.getLogger(MetadataImport.class);
    }
}

