/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InitializeEntities {
    private static final Logger log = LogManager.getLogger();
    private RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    private RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    private EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();

    private InitializeEntities() {
    }

    public static void main(String[] argv) throws SQLException, AuthorizeException, ParseException {
        InitializeEntities initializeEntities = new InitializeEntities();
        PosixParser parser = new PosixParser();
        Options options = InitializeEntities.createCommandLineOptions();
        CommandLine line = parser.parse(options, argv);
        String fileLocation = InitializeEntities.getFileLocationFromCommandLine(line);
        InitializeEntities.checkHelpEntered(options, line);
        initializeEntities.run(fileLocation);
    }

    private static void checkHelpEntered(Options options, CommandLine line) {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Intialize Entities", options);
            System.exit(0);
        }
    }

    private static String getFileLocationFromCommandLine(CommandLine line) {
        String query = line.getOptionValue("f");
        if (StringUtils.isEmpty((CharSequence)query)) {
            System.out.println("No file location was entered");
            log.info("No file location was entered");
            System.exit(1);
        }
        return query;
    }

    protected static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("f", "file", true, "the location for the file containing the xml data");
        return options;
    }

    private void run(String fileLocation) throws SQLException, AuthorizeException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        this.parseXMLToRelations(context, fileLocation);
        context.complete();
    }

    private void parseXMLToRelations(Context context, String fileLocation) throws AuthorizeException {
        try {
            File fXmlFile = new File(fileLocation);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("type");
            LinkedList relationshipTypes = new LinkedList();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node;
                int j;
                Node nNode = nList.item(i);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String leftType = eElement.getElementsByTagName("leftType").item(0).getTextContent();
                String rightType = eElement.getElementsByTagName("rightType").item(0).getTextContent();
                String leftLabel = eElement.getElementsByTagName("leftLabel").item(0).getTextContent();
                String rightLabel = eElement.getElementsByTagName("rightLabel").item(0).getTextContent();
                NodeList leftCardinalityList = eElement.getElementsByTagName("leftCardinality");
                NodeList rightCardinalityList = eElement.getElementsByTagName("rightCardinality");
                String leftCardinalityMin = "";
                String leftCardinalityMax = "";
                String rightCardinalityMin = "";
                String rightCardinalityMax = "";
                for (j = 0; j < leftCardinalityList.getLength(); ++j) {
                    node = leftCardinalityList.item(j);
                    leftCardinalityMin = this.getString(leftCardinalityMin, (Element)node, "min");
                    leftCardinalityMax = this.getString(leftCardinalityMax, (Element)node, "max");
                }
                for (j = 0; j < rightCardinalityList.getLength(); ++j) {
                    node = rightCardinalityList.item(j);
                    rightCardinalityMin = this.getString(rightCardinalityMin, (Element)node, "min");
                    rightCardinalityMax = this.getString(rightCardinalityMax, (Element)node, "max");
                }
                this.populateRelationshipType(context, leftType, rightType, leftLabel, rightLabel, leftCardinalityMin, leftCardinalityMax, rightCardinalityMin, rightCardinalityMax);
            }
        }
        catch (IOException | SQLException | ParserConfigurationException | SAXException e) {
            log.error("An error occurred while parsing the XML file to relations", (Throwable)e);
        }
    }

    private String getString(String leftCardinalityMin, Element node, String minOrMax) {
        if (node.getElementsByTagName(minOrMax).getLength() > 0) {
            leftCardinalityMin = node.getElementsByTagName(minOrMax).item(0).getTextContent();
        }
        return leftCardinalityMin;
    }

    private void populateRelationshipType(Context context, String leftType, String rightType, String leftLabel, String rightLabel, String leftCardinalityMin, String leftCardinalityMax, String rightCardinalityMin, String rightCardinalityMax) throws SQLException, AuthorizeException {
        EntityType rightEntityType;
        EntityType leftEntityType = this.entityTypeService.findByEntityType(context, leftType);
        if (leftEntityType == null) {
            leftEntityType = this.entityTypeService.create(context, leftType);
        }
        if ((rightEntityType = this.entityTypeService.findByEntityType(context, rightType)) == null) {
            rightEntityType = this.entityTypeService.create(context, rightType);
        }
        Integer leftCardinalityMinInteger = StringUtils.isNotBlank((CharSequence)leftCardinalityMin) ? Integer.valueOf(Integer.parseInt(leftCardinalityMin)) : null;
        Integer leftCardinalityMaxInteger = StringUtils.isNotBlank((CharSequence)leftCardinalityMax) ? Integer.valueOf(Integer.parseInt(leftCardinalityMax)) : null;
        Integer rightCardinalityMinInteger = StringUtils.isNotBlank((CharSequence)rightCardinalityMin) ? Integer.valueOf(Integer.parseInt(rightCardinalityMin)) : null;
        Integer rightCardinalityMaxInteger = StringUtils.isNotBlank((CharSequence)rightCardinalityMax) ? Integer.valueOf(Integer.parseInt(rightCardinalityMax)) : null;
        RelationshipType relationshipType = this.relationshipTypeService.findbyTypesAndLabels(context, leftEntityType, rightEntityType, leftLabel, rightLabel);
        if (relationshipType == null) {
            this.relationshipTypeService.create(context, leftEntityType, rightEntityType, leftLabel, rightLabel, leftCardinalityMinInteger, leftCardinalityMaxInteger, rightCardinalityMinInteger, rightCardinalityMaxInteger);
        } else {
            relationshipType.setLeftMinCardinality(leftCardinalityMinInteger);
            relationshipType.setLeftMaxCardinality(leftCardinalityMaxInteger);
            relationshipType.setRightMinCardinality(rightCardinalityMinInteger);
            relationshipType.setRightMaxCardinality(rightCardinalityMaxInteger);
            this.relationshipTypeService.update(context, relationshipType);
        }
    }
}

