/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ShibAuthentication
implements AuthenticationMethod {
    private static Logger log = LogManager.getLogger(ShibAuthentication.class);
    protected Map<String, String> metadataHeaderMap = null;
    protected final int NAME_MAX_SIZE = 64;
    protected final int PHONE_MAX_SIZE = 32;
    protected final int METADATA_MAX_SIZE = 1024;
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected final String COLUMN_NAME_REGEX = "^[_A-Za-z0-9]+$";

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        boolean swordCompatibility = this.configurationService.getBooleanProperty("authentication-shibboleth.sword.compatibility", true);
        if (swordCompatibility && username != null && username.length() > 0 && password != null && password.length() > 0) {
            return this.swordCompatibility(context, username, password, request);
        }
        if (request == null) {
            log.warn("Unable to authenticate using Shibboleth because the request object is null.");
            return 5;
        }
        this.initialize(context);
        if (log.isDebugEnabled()) {
            log.debug("Starting Shibboleth Authentication");
            String message = "Received the following headers:\n";
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    message = message + "" + headerName + "='" + headerValue + "'\n";
                }
            }
            log.debug(message);
        }
        boolean autoRegister = this.configurationService.getBooleanProperty("authentication-shibboleth.autoregister", true);
        try {
            EPerson eperson = this.findEPerson(context, request);
            if (eperson == null && autoRegister) {
                eperson = this.registerNewEPerson(context, request);
            }
            if (eperson == null) {
                return 4;
            }
            this.updateEPerson(context, request, eperson);
            context.setCurrentUser(eperson);
            request.getSession().setAttribute("shib.authenticated", (Object)true);
            AuthenticateServiceFactory.getInstance().getAuthenticationService().initEPerson(context, request, eperson);
            log.info(eperson.getEmail() + " has been authenticated via shibboleth.");
            return 1;
        }
        catch (Throwable t) {
            log.error("Unable to successfully authenticate using shibboleth for user because of an exception.", t);
            context.setCurrentUser(null);
            return 4;
        }
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) {
        try {
            if (request == null || context.getCurrentUser() == null || request.getSession().getAttribute("shib.authenticated") == null) {
                return Collections.EMPTY_LIST;
            }
            if (request.getSession().getAttribute("shib.specialgroup") != null) {
                log.debug("Returning cached special groups.");
                List sessionGroupIds = (List)request.getSession().getAttribute("shib.specialgroup");
                ArrayList<Group> result = new ArrayList<Group>();
                for (UUID uuid : sessionGroupIds) {
                    result.add((Group)this.groupService.find(context, uuid));
                }
                return result;
            }
            log.debug("Starting to determine special groups");
            Object[] defaultRoles = this.configurationService.getArrayProperty("authentication-shibboleth.default-roles");
            String roleHeader = this.configurationService.getProperty("authentication-shibboleth.role-header");
            boolean ignoreScope = this.configurationService.getBooleanProperty("authentication-shibboleth.role-header.ignore-scope", true);
            boolean ignoreValue = this.configurationService.getBooleanProperty("authentication-shibboleth.role-header.ignore-value", false);
            if (ignoreScope && ignoreValue) {
                throw new IllegalStateException("Both config parameters for ignoring an roll attributes scope and value are turned on, this is not a permissable configuration. (Note: ignore-scope defaults to true) The configuration parameters are: 'authentication.shib.role-header.ignore-scope' and 'authentication.shib.role-header.ignore-value'");
            }
            List<String> affiliations = this.findMultipleAttributes(request, roleHeader);
            if (affiliations == null) {
                if (defaultRoles != null) {
                    affiliations = Arrays.asList(defaultRoles);
                }
                log.debug("Failed to find Shibboleth role header, '" + roleHeader + "', falling back to the default roles: '" + StringUtils.join((Object[])defaultRoles, (String)",") + "'");
            } else {
                log.debug("Found Shibboleth role header: '" + roleHeader + "' = '" + affiliations + "'");
            }
            HashSet<Group> groups = new HashSet<Group>();
            if (affiliations != null) {
                for (String affiliation : affiliations) {
                    Object[] groupNames;
                    int index;
                    if (ignoreScope && (index = affiliation.indexOf(64)) != -1) {
                        affiliation = affiliation.substring(0, index);
                    }
                    if (ignoreValue && (index = affiliation.indexOf(64)) != -1) {
                        affiliation = affiliation.substring(index + 1, affiliation.length());
                    }
                    if ((groupNames = this.configurationService.getArrayProperty("authentication-shibboleth.role." + affiliation)) == null || groupNames.length == 0) {
                        groupNames = this.configurationService.getArrayProperty("authentication-shibboleth.role." + affiliation.toLowerCase());
                    }
                    if (groupNames == null) {
                        log.debug("Unable to find role mapping for the value, '" + affiliation + "', there should be a mapping in config/modules/authentication-shibboleth.cfg:  role." + affiliation + " = <some group name>");
                        continue;
                    }
                    log.debug("Mapping role affiliation to DSpace group: '" + StringUtils.join((Object[])groupNames, (String)",") + "'");
                    for (int i = 0; i < groupNames.length; ++i) {
                        try {
                            Group group = this.groupService.findByName(context, ((String)groupNames[i]).trim());
                            if (group != null) {
                                groups.add(group);
                                continue;
                            }
                            log.debug("Unable to find group: '" + ((String)groupNames[i]).trim() + "'");
                            continue;
                        }
                        catch (SQLException sqle) {
                            log.error("Exception thrown while trying to lookup affiliation role for group name: '" + ((String)groupNames[i]).trim() + "'", (Throwable)sqle);
                        }
                    }
                }
            }
            log.info("Added current EPerson to special groups: " + groups);
            ArrayList<UUID> groupIds = new ArrayList<UUID>();
            for (Group group : groups) {
                groupIds.add(group.getID());
            }
            request.getSession().setAttribute("shib.specialgroup", groupIds);
            return new ArrayList<Group>(groups);
        }
        catch (Throwable t) {
            log.error("Unable to validate any sepcial groups this user may belong too because of an exception.", t);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String email) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        boolean lazySession = this.configurationService.getBooleanProperty("authentication-shibboleth.lazysession", false);
        if (lazySession) {
            String shibURL = this.configurationService.getProperty("authentication-shibboleth.lazysession.loginurl");
            boolean forceHTTPS = this.configurationService.getBooleanProperty("authentication-shibboleth.lazysession.secure", true);
            if (shibURL == null || shibURL.length() == 0) {
                shibURL = "/Shibboleth.sso/Login";
            }
            shibURL = shibURL.trim();
            String host = request.getServerName();
            int port = request.getServerPort();
            String contextPath = request.getContextPath();
            String returnURL = request.getHeader("Referer");
            if (returnURL == null) {
                returnURL = request.isSecure() || forceHTTPS ? "https://" : "http://";
                returnURL = returnURL + host;
                if (port != 443 && port != 80) {
                    returnURL = returnURL + ":" + port;
                }
            }
            try {
                shibURL = shibURL + "?target=" + URLEncoder.encode(returnURL, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                log.error("Unable to generate lazysession authentication", (Throwable)uee);
            }
            log.debug("Redirecting user to Shibboleth initiator: " + shibURL);
            return response.encodeRedirectURL(shibURL);
        }
        return response.encodeRedirectURL(request.getContextPath() + "/shibboleth-login");
    }

    @Override
    public String getName() {
        return "shibboleth";
    }

    protected EPerson findEPerson(Context context, HttpServletRequest request) throws SQLException, AuthorizeException {
        String email;
        String netid;
        boolean isUsingTomcatUser = this.configurationService.getBooleanProperty("authentication-shibboleth.email-use-tomcat-remote-user");
        String netidHeader = this.configurationService.getProperty("authentication-shibboleth.netid-header");
        String emailHeader = this.configurationService.getProperty("authentication-shibboleth.email-header");
        EPerson eperson = null;
        boolean foundNetID = false;
        boolean foundEmail = false;
        boolean foundRemoteUser = false;
        if (netidHeader != null && (netid = this.findSingleAttribute(request, netidHeader)) != null) {
            foundNetID = true;
            eperson = this.ePersonService.findByNetid(context, netid);
            if (eperson == null) {
                log.info("Unable to identify EPerson based upon Shibboleth netid header: '" + netidHeader + "'='" + netid + "'.");
            } else {
                log.debug("Identified EPerson based upon Shibboleth netid header: '" + netidHeader + "'='" + netid + "'.");
            }
        }
        if (eperson == null && emailHeader != null && (email = this.findSingleAttribute(request, emailHeader)) != null) {
            foundEmail = true;
            eperson = this.ePersonService.findByEmail(context, email = email.toLowerCase());
            if (eperson == null) {
                log.info("Unable to identify EPerson based upon Shibboleth email header: '" + emailHeader + "'='" + email + "'.");
            } else {
                log.info("Identified EPerson based upon Shibboleth email header: '" + emailHeader + "'='" + email + "'.");
            }
            if (eperson != null && eperson.getNetid() != null) {
                log.error("The identified EPerson based upon Shibboleth email header, '" + emailHeader + "'='" + email + "', is locked to another netid: '" + eperson.getNetid() + "'. This might be a possible hacking attempt to steal another users credentials. If the user's netid has changed you will need to manually change it to the correct value or unset it in the database.");
                eperson = null;
            }
        }
        if (eperson == null && isUsingTomcatUser && (email = request.getRemoteUser()) != null) {
            foundRemoteUser = true;
            eperson = this.ePersonService.findByEmail(context, email = email.toLowerCase());
            if (eperson == null) {
                log.info("Unable to identify EPerson based upon Tomcat's remote user: '" + email + "'.");
            } else {
                log.info("Identified EPerson based upon Tomcat's remote user: '" + email + "'.");
            }
            if (eperson != null && eperson.getNetid() != null) {
                log.error("The identified EPerson based upon Tomcat's remote user, '" + email + "', is locked to another netid: '" + eperson.getNetid() + "'. This might be a possible hacking attempt to steal another users credentials. If the user's netid has changed you will need to manually change it to the correct value or unset it in the database.");
                eperson = null;
            }
        }
        if (!(foundNetID || foundEmail || foundRemoteUser)) {
            log.error("Shibboleth authentication was not able to find a NetId, Email, or Tomcat Remote user for which to indentify a user from.");
        }
        return eperson;
    }

    protected EPerson registerNewEPerson(Context context, HttpServletRequest request) throws SQLException, AuthorizeException {
        String netidHeader = this.configurationService.getProperty("authentication-shibboleth.netid-header");
        String emailHeader = this.configurationService.getProperty("authentication-shibboleth.email-header");
        String fnameHeader = this.configurationService.getProperty("authentication-shibboleth.firstname-header");
        String lnameHeader = this.configurationService.getProperty("authentication-shibboleth.lastname-header");
        String netid = this.findSingleAttribute(request, netidHeader);
        String email = this.findSingleAttribute(request, emailHeader);
        String fname = this.findSingleAttribute(request, fnameHeader);
        String lname = this.findSingleAttribute(request, lnameHeader);
        if (email == null || fnameHeader != null && fname == null || lnameHeader != null && lname == null) {
            String message = "Unable to register new eperson because we are unable to find an email address along with first and last name for the user.\n";
            message = message + "  NetId Header: '" + netidHeader + "'='" + netid + "' (Optional) \n";
            message = message + "  Email Header: '" + emailHeader + "'='" + email + "' \n";
            message = message + "  First Name Header: '" + fnameHeader + "'='" + fname + "' \n";
            message = message + "  Last Name Header: '" + lnameHeader + "'='" + lname + "'";
            log.error(message);
            return null;
        }
        if (fname != null && fname.length() > 64) {
            log.warn("Truncating eperson's first name because it is longer than 64: '" + fname + "'");
            fname = fname.substring(0, 64);
        }
        if (lname != null && lname.length() > 64) {
            log.warn("Truncating eperson's last name because it is longer than 64: '" + lname + "'");
            lname = lname.substring(0, 64);
        }
        context.turnOffAuthorisationSystem();
        EPerson eperson = this.ePersonService.create(context);
        if (netid != null) {
            eperson.setNetid(netid);
        }
        eperson.setEmail(email.toLowerCase());
        if (fname != null) {
            eperson.setFirstName(context, fname);
        }
        if (lname != null) {
            eperson.setLastName(context, lname);
        }
        eperson.setCanLogIn(true);
        AuthenticateServiceFactory.getInstance().getAuthenticationService().initEPerson(context, request, eperson);
        this.ePersonService.update(context, eperson);
        context.dispatchEvents();
        context.restoreAuthSystemState();
        if (log.isInfoEnabled()) {
            String message = "Auto registered new eperson using Shibboleth-based attributes:";
            if (netid != null) {
                message = message + "  NetId: '" + netid + "'\n";
            }
            message = message + "  Email: '" + email + "' \n";
            message = message + "  First Name: '" + fname + "' \n";
            message = message + "  Last Name: '" + lname + "'";
            log.info(message);
        }
        return eperson;
    }

    protected void updateEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException, AuthorizeException {
        String netidHeader = this.configurationService.getProperty("authentication-shibboleth.netid-header");
        String emailHeader = this.configurationService.getProperty("authentication-shibboleth.email-header");
        String fnameHeader = this.configurationService.getProperty("authentication-shibboleth.firstname-header");
        String lnameHeader = this.configurationService.getProperty("authentication-shibboleth.lastname-header");
        String netid = this.findSingleAttribute(request, netidHeader);
        String email = this.findSingleAttribute(request, emailHeader);
        String fname = this.findSingleAttribute(request, fnameHeader);
        String lname = this.findSingleAttribute(request, lnameHeader);
        if (fname != null && fname.length() > 64) {
            log.warn("Truncating eperson's first name because it is longer than 64: '" + fname + "'");
            fname = fname.substring(0, 64);
        }
        if (lname != null && lname.length() > 64) {
            log.warn("Truncating eperson's last name because it is longer than 64: '" + lname + "'");
            lname = lname.substring(0, 64);
        }
        context.turnOffAuthorisationSystem();
        if (netid != null && eperson.getNetid() == null) {
            eperson.setNetid(netid);
        }
        if (email != null) {
            eperson.setEmail(email.toLowerCase());
        }
        if (fname != null) {
            eperson.setFirstName(context, fname);
        }
        if (lname != null) {
            eperson.setLastName(context, lname);
        }
        if (log.isDebugEnabled()) {
            String message = "Updated the eperson's minimal metadata: \n";
            message = message + " Email Header: '" + emailHeader + "' = '" + email + "' \n";
            message = message + " First Name Header: '" + fnameHeader + "' = '" + fname + "' \n";
            message = message + " Last Name Header: '" + fnameHeader + "' = '" + lname + "'";
            log.debug(message);
        }
        for (String header : this.metadataHeaderMap.keySet()) {
            String field = this.metadataHeaderMap.get(header);
            String value = this.findSingleAttribute(request, header);
            if (value == null) {
                log.warn("Unable to update the eperson's '" + field + "' metadata because the header '" + header + "' does not exist.");
                continue;
            }
            if ("phone".equals(field) && value.length() > 32) {
                log.warn("Truncating eperson phone metadata because it is longer than 32: '" + value + "'");
                value = value.substring(0, 32);
            } else if (value.length() > 1024) {
                log.warn("Truncating eperson " + field + " metadata because it is longer than " + 1024 + ": '" + value + "'");
                value = value.substring(0, 1024);
            }
            this.ePersonService.setMetadata(context, eperson, field, value);
            log.debug("Updated the eperson's '" + field + "' metadata using header: '" + header + "' = '" + value + "'.");
        }
        this.ePersonService.update(context, eperson);
        context.dispatchEvents();
        context.restoreAuthSystemState();
    }

    protected int swordCompatibility(Context context, String username, String password, HttpServletRequest request) throws SQLException {
        EPerson eperson = null;
        log.debug("Shibboleth Sword compatibility activated.");
        eperson = this.ePersonService.findByEmail(context, username.toLowerCase());
        if (eperson == null) {
            log.error("Shibboleth-based password authentication failed for user " + username + " because no such user exists.");
            return 4;
        }
        if (!eperson.canLogIn()) {
            log.error("Shibboleth-based password authentication failed for user " + username + " because the eperson object is not allowed to login.");
            return 5;
        }
        if (eperson.getRequireCertificate()) {
            log.error("Shibboleth-based password authentication failed for user " + username + " because the eperson object requires a certificate to authenticate..");
            return 3;
        }
        if (this.ePersonService.checkPassword(context, eperson, password)) {
            AuthenticateServiceFactory.getInstance().getAuthenticationService().initEPerson(context, request, eperson);
            context.setCurrentUser(eperson);
            log.info(eperson.getEmail() + " has been authenticated via shibboleth using password-based sword compatibility mode.");
            return 1;
        }
        log.error("Shibboleth-based password authentication failed for user " + username + " because a bad password was supplied.");
        return 2;
    }

    protected synchronized void initialize(Context context) throws SQLException {
        if (this.metadataHeaderMap != null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Object[] mappingString = this.configurationService.getArrayProperty("authentication-shibboleth.eperson.metadata");
        boolean autoCreate = this.configurationService.getBooleanProperty("authentication-shibboleth.eperson.metadata.autocreate", true);
        if (mappingString == null || mappingString.length == 0) {
            log.debug("No additional eperson metadata mapping found: authentication.shib.eperson.metadata");
            this.metadataHeaderMap = map;
            return;
        }
        log.debug("Loading additional eperson metadata from: 'authentication.shib.eperson.metadata' = '" + StringUtils.join((Object[])mappingString, (String)",") + "'");
        for (Object metadataString : mappingString) {
            String[] metadataParts = ((String)(metadataString = ((String)metadataString).trim())).split("=>");
            if (metadataParts.length != 2) {
                log.error("Unable to parse metadat mapping string: '" + (String)metadataString + "'");
                continue;
            }
            String header = metadataParts[0].trim();
            String name = metadataParts[1].trim().toLowerCase();
            boolean valid = this.checkIfEpersonMetadataFieldExists(context, name);
            if (!valid && autoCreate) {
                valid = this.autoCreateEpersonMetadataField(context, name);
            }
            if (valid) {
                log.debug("Loading additional eperson metadata mapping for: '" + header + "' = '" + name + "'");
                map.put(header, name);
                continue;
            }
            log.error("Skipping the additional eperson metadata mapping for: '" + header + "' = '" + name + "' because the field is not supported by the current configuration.");
        }
        this.metadataHeaderMap = map;
    }

    protected synchronized boolean checkIfEpersonMetadataFieldExists(Context context, String metadataName) throws SQLException {
        if (metadataName == null) {
            return false;
        }
        if ("phone".equals(metadataName)) {
            return true;
        }
        MetadataField metadataField = this.metadataFieldService.findByElement(context, "eperson", metadataName, null);
        return metadataField != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean autoCreateEpersonMetadataField(Context context, String metadataName) throws SQLException {
        if (metadataName == null) {
            return false;
        }
        if ("phone".equals(metadataName)) {
            return true;
        }
        if (!metadataName.matches("^[_A-Za-z0-9]+$")) {
            return false;
        }
        MetadataSchema epersonSchema = this.metadataSchemaService.find(context, "eperson");
        MetadataField metadataField = null;
        try {
            context.turnOffAuthorisationSystem();
            metadataField = this.metadataFieldService.create(context, epersonSchema, metadataName, null, null);
        }
        catch (AuthorizeException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (NonUniqueMetadataException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            context.restoreAuthSystemState();
        }
        return metadataField != null;
    }

    protected String findAttribute(HttpServletRequest request, String name) {
        if (name == null) {
            return null;
        }
        String value = (String)request.getAttribute(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = (String)request.getAttribute(name.toLowerCase());
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = (String)request.getAttribute(name.toUpperCase());
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = request.getHeader(name);
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = request.getHeader(name.toLowerCase());
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = request.getHeader(name.toUpperCase());
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            log.debug("ShibAuthentication - attribute " + name + " is empty!");
            return null;
        }
        boolean reconvertAttributes = this.configurationService.getBooleanProperty("authentication-shibboleth.reconvert.attributes", false);
        if (!StringUtils.isEmpty((CharSequence)value) && reconvertAttributes) {
            try {
                value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                log.warn("Failed to reconvert shibboleth attribute (" + name + ").", (Throwable)ex);
            }
        }
        return value;
    }

    protected String findSingleAttribute(HttpServletRequest request, String name) {
        if (name == null) {
            return null;
        }
        String value = this.findAttribute(request, name);
        if (value != null) {
            int idx = 0;
            do {
                if ((idx = value.indexOf(59, idx)) == -1 || value.charAt(idx - 1) == '\\') continue;
                value = value.substring(0, idx);
                break;
            } while (idx >= 0);
            value = value.replaceAll("\\;", ";");
        }
        return value;
    }

    protected List<String> findMultipleAttributes(HttpServletRequest request, String name) {
        String values = this.findAttribute(request, name);
        if (values == null) {
            return null;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        int idx = 0;
        do {
            if ((idx = values.indexOf(59, idx)) == 0) {
                values = values.substring(1, values.length());
                continue;
            }
            if (idx > 0 && values.charAt(idx - 1) == '\\') {
                ++idx;
                continue;
            }
            if (idx <= 0) continue;
            String value = values.substring(0, idx);
            value = value.replaceAll("\\\\;", ";");
            valueList.add(value);
            values = values.substring(idx + 1, values.length());
            idx = 0;
        } while (idx >= 0);
        if (values.length() > 0) {
            values = values.replaceAll("\\\\;", ";");
            valueList.add(values);
        }
        return valueList;
    }
}

