/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.content.Collection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.SelfNamedPlugin;

public class DCInputAuthority
extends SelfNamedPlugin
implements ChoiceAuthority {
    private static Logger log = LogManager.getLogger(DCInputAuthority.class);
    private String[] values = null;
    private String[] labels = null;
    private static DCInputsReader dci = null;
    private static String[] pluginNames = null;

    public static String[] getPluginNames() {
        if (pluginNames == null) {
            DCInputAuthority.initPluginNames();
        }
        return (String[])ArrayUtils.clone((Object[])pluginNames);
    }

    private static synchronized void initPluginNames() {
        if (pluginNames == null) {
            try {
                if (dci == null) {
                    dci = new DCInputsReader();
                }
            }
            catch (DCInputsReaderException e) {
                log.error("Failed reading DCInputs initialization: ", (Throwable)e);
            }
            ArrayList<String> names = new ArrayList<String>();
            Iterator<String> pi = dci.getPairsNameIterator();
            while (pi.hasNext()) {
                names.add(pi.next());
            }
            pluginNames = names.toArray(new String[names.size()]);
            log.debug("Got plugin names = " + Arrays.deepToString(pluginNames));
        }
    }

    private void init() {
        if (this.values == null) {
            String pname = this.getPluginInstanceName();
            List<String> pairs = dci.getPairs(pname);
            if (pairs != null) {
                this.values = new String[pairs.size() / 2];
                this.labels = new String[pairs.size() / 2];
                for (int i = 0; i < pairs.size(); i += 2) {
                    this.labels[i / 2] = pairs.get(i);
                    this.values[i / 2] = pairs.get(i + 1);
                }
                log.debug("Found pairs for name=" + pname);
            } else {
                log.error("Failed to find any pairs for name=" + pname, (Throwable)new IllegalStateException());
            }
        }
    }

    @Override
    public Choices getMatches(String field, String query, Collection collection, int start, int limit, String locale) {
        this.init();
        int dflt = -1;
        Choice[] v = new Choice[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            v[i] = new Choice(this.values[i], this.values[i], this.labels[i]);
            if (!this.values[i].equalsIgnoreCase(query)) continue;
            dflt = i;
        }
        return new Choices(v, 0, v.length, 400, false, dflt);
    }

    @Override
    public Choices getBestMatch(String field, String text, Collection collection, String locale) {
        this.init();
        for (int i = 0; i < this.values.length; ++i) {
            if (!text.equalsIgnoreCase(this.values[i])) continue;
            Choice[] v = new Choice[]{new Choice(String.valueOf(i), this.values[i], this.labels[i])};
            return new Choices(v, 0, v.length, 500, false, 0);
        }
        return new Choices(300);
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        this.init();
        int pos = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(key)) continue;
            pos = i;
            break;
        }
        if (pos != -1) {
            return this.labels[pos];
        }
        return "UNKNOWN KEY " + key;
    }
}

