/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;

public class FacetYearRange {
    private static final Pattern PATTERN = Pattern.compile("\\[(.*? TO .*?)\\]");
    private DiscoverySearchFilterFacet facet;
    private String dateFacet;
    private int oldestYear = -1;
    private int newestYear = -1;

    public FacetYearRange(DiscoverySearchFilterFacet facet) {
        this.facet = facet;
    }

    public String getDateFacet() {
        return this.dateFacet;
    }

    public int getOldestYear() {
        return this.oldestYear;
    }

    public int getNewestYear() {
        return this.newestYear;
    }

    public boolean isValid() {
        return this.oldestYear != -1 && this.newestYear != -1;
    }

    public void calculateRange(Context context, List<String> filterQueries, IndexableObject scope, SearchService searchService, DiscoverQuery parentQuery) throws SearchServiceException {
        this.dateFacet = this.facet.getIndexFieldName() + ".year";
        this.lookupPreviousRangeInFilterQueries(filterQueries);
        if (this.oldestYear == -1 && this.newestYear == -1) {
            this.calculateNewRangeBasedOnSearchIndex(context, filterQueries, scope, searchService, parentQuery);
        }
    }

    private void lookupPreviousRangeInFilterQueries(List<String> filterQueries) {
        for (String filterQuery : filterQueries) {
            if (!filterQuery.startsWith(this.dateFacet + ":")) continue;
            Matcher matcher = PATTERN.matcher(filterQuery);
            boolean hasPattern = matcher.find();
            if (hasPattern) {
                filterQuery = matcher.group(0);
                int tempOldYear = Integer.parseInt(filterQuery.split(" TO ")[0].replace("[", "").trim());
                int tempNewYear = Integer.parseInt(filterQuery.split(" TO ")[1].replace("]", "").trim());
                if (tempNewYear >= this.newestYear && this.oldestYear >= tempOldYear && this.newestYear != -1) continue;
                this.oldestYear = tempOldYear;
                this.newestYear = tempNewYear;
                continue;
            }
            if (filterQuery.indexOf(" OR ") != -1) {
                filterQuery = filterQuery.split(" OR ")[0];
            }
            this.newestYear = this.oldestYear = Integer.parseInt(filterQuery.split(":")[1].trim());
            break;
        }
    }

    private void calculateNewRangeBasedOnSearchIndex(Context context, List<String> filterQueries, IndexableObject scope, SearchService searchService, DiscoverQuery parentQuery) throws SearchServiceException {
        List<DiscoverResult.SearchDocument> searchDocuments;
        List<DiscoverResult.SearchDocument> searchDocuments2;
        DiscoverQuery yearRangeQuery = new DiscoverQuery();
        yearRangeQuery.setDiscoveryConfigurationName(parentQuery.getDiscoveryConfigurationName());
        yearRangeQuery.setMaxResults(1);
        yearRangeQuery.addFieldPresentQueries(this.dateFacet);
        yearRangeQuery.setSortField(this.dateFacet + "_sort", DiscoverQuery.SORT_ORDER.asc);
        yearRangeQuery.addFilterQueries(filterQueries.toArray(new String[filterQueries.size()]));
        yearRangeQuery.addSearchField(this.dateFacet);
        DiscoverResult lastYearResult = searchService.search(context, scope, yearRangeQuery);
        if (0 < lastYearResult.getIndexableObjects().size() && 0 < (searchDocuments2 = lastYearResult.getSearchDocument(lastYearResult.getIndexableObjects().get(0))).size() && 0 < searchDocuments2.get(0).getSearchFieldValues(this.dateFacet).size()) {
            this.oldestYear = Integer.parseInt(searchDocuments2.get(0).getSearchFieldValues(this.dateFacet).get(0));
        }
        yearRangeQuery.setSortField(this.dateFacet + "_sort", DiscoverQuery.SORT_ORDER.desc);
        DiscoverResult firstYearResult = searchService.search(context, scope, yearRangeQuery);
        if (0 < firstYearResult.getIndexableObjects().size() && 0 < (searchDocuments = firstYearResult.getSearchDocument(firstYearResult.getIndexableObjects().get(0))).size() && 0 < searchDocuments.get(0).getSearchFieldValues(this.dateFacet).size()) {
            this.newestYear = Integer.parseInt(searchDocuments.get(0).getSearchFieldValues(this.dateFacet).get(0));
        }
    }

    public int getYearGap() {
        int gap = 1;
        int yearDifference = this.newestYear - this.oldestYear;
        if (yearDifference != 0) {
            gap = this.round((double)yearDifference / (double)this.facet.getFacetLimit(), 10);
        }
        return gap;
    }

    private int round(double number, int multiple) {
        int result = new Double(Math.ceil(number)).intValue();
        if (result % multiple != 0) {
            int division = result / multiple + 1;
            result = division * multiple;
        }
        return result;
    }
}

