/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

public class EPersonCLITool {
    private static final Option VERB_ADD = new Option("a", "add", false, "create a new EPerson");
    private static final Option VERB_DELETE = new Option("d", "delete", false, "delete an existing EPerson");
    private static final Option VERB_LIST = new Option("L", "list", false, "list EPersons");
    private static final Option VERB_MODIFY = new Option("M", "modify", false, "modify an EPerson");
    private static final Option OPT_GIVENNAME = new Option("g", "givenname", true, "the person's actual first or personal name");
    private static final Option OPT_SURNAME = new Option("s", "surname", true, "the person's actual last or family name");
    private static final Option OPT_PHONE = new Option("t", "telephone", true, "telephone number, empty for none");
    private static final Option OPT_LANGUAGE = new Option("l", "language", true, "the person's preferred language");
    private static final Option OPT_REQUIRE_CERTIFICATE = new Option("c", "requireCertificate", true, "if 'true', an X.509 certificate will be required for login");
    private static final Option OPT_CAN_LOGIN = new Option("C", "canLogIn", true, "'true' if the user can log in");
    private static final Option OPT_EMAIL = new Option("m", "email", true, "the user's email address, empty for none");
    private static final Option OPT_NETID = new Option("n", "netid", true, "network ID associated with the person, empty for none");
    private static final Option OPT_NEW_EMAIL = new Option("i", "newEmail", true, "new email address");
    private static final Option OPT_NEW_NETID = new Option("I", "newNetid", true, "new network ID");
    private static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    private EPersonCLITool() {
    }

    public static void main(String[] argv) throws ParseException, SQLException, AuthorizeException {
        OptionGroup VERBS = new OptionGroup();
        VERBS.addOption(VERB_ADD);
        VERBS.addOption(VERB_DELETE);
        VERBS.addOption(VERB_LIST);
        VERBS.addOption(VERB_MODIFY);
        Options globalOptions = new Options();
        globalOptions.addOptionGroup(VERBS);
        globalOptions.addOption("h", "help", false, "explain options");
        GnuParser parser = new GnuParser();
        CommandLine command = parser.parse(globalOptions, argv, true);
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        int status = 0;
        if (command.hasOption(VERB_ADD.getOpt())) {
            status = EPersonCLITool.cmdAdd(context, argv);
        } else if (command.hasOption(VERB_DELETE.getOpt())) {
            status = EPersonCLITool.cmdDelete(context, argv);
        } else if (command.hasOption(VERB_MODIFY.getOpt())) {
            status = EPersonCLITool.cmdModify(context, argv);
        } else if (command.hasOption(VERB_LIST.getOpt())) {
            status = EPersonCLITool.cmdList(context, argv);
        } else if (command.hasOption('h')) {
            new HelpFormatter().printHelp("user [options]", globalOptions);
        } else {
            System.err.println("Unknown operation.");
            new HelpFormatter().printHelp("user [options]", globalOptions);
            context.abort();
            status = 1;
            throw new IllegalArgumentException();
        }
        if (context.isValid()) {
            try {
                context.complete();
            }
            catch (SQLException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    private static int cmdAdd(Context context, String[] argv) throws AuthorizeException, SQLException {
        CommandLine command;
        Options options = new Options();
        options.addOption(VERB_ADD);
        OptionGroup identityOptions = new OptionGroup();
        identityOptions.addOption(OPT_EMAIL);
        identityOptions.addOption(OPT_NETID);
        options.addOptionGroup(identityOptions);
        options.addOption(OPT_GIVENNAME);
        options.addOption(OPT_SURNAME);
        options.addOption(OPT_PHONE);
        options.addOption(OPT_LANGUAGE);
        options.addOption(OPT_REQUIRE_CERTIFICATE);
        Option option = new Option("p", "password", true, "password to match the EPerson name");
        options.addOption(option);
        options.addOption("h", "help", false, "explain --add options");
        GnuParser parser = new GnuParser();
        try {
            command = parser.parse(options, argv);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        if (command.hasOption('h')) {
            new HelpFormatter().printHelp("user --add [options]", options);
            return 0;
        }
        if (!command.hasOption(OPT_EMAIL.getOpt()) && !command.hasOption(OPT_NETID.getOpt())) {
            System.err.println("You must provide an email address or a netid to identify the new user.");
            return 1;
        }
        if (!command.hasOption('p')) {
            System.err.println("You must provide a password for the new user.");
            return 1;
        }
        EPerson eperson = null;
        try {
            eperson = ePersonService.create(context);
        }
        catch (SQLException ex) {
            context.abort();
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (AuthorizeException ex) {
            // empty catch block
        }
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(false);
        eperson.setEmail(command.getOptionValue(OPT_EMAIL.getOpt()));
        eperson.setFirstName(context, command.getOptionValue(OPT_GIVENNAME.getOpt()));
        eperson.setLastName(context, command.getOptionValue(OPT_SURNAME.getOpt()));
        eperson.setLanguage(context, command.getOptionValue(OPT_LANGUAGE.getOpt(), Locale.getDefault().getLanguage()));
        ePersonService.setMetadata(context, eperson, "phone", command.getOptionValue(OPT_PHONE.getOpt()));
        eperson.setNetid(command.getOptionValue(OPT_NETID.getOpt()));
        ePersonService.setPassword(eperson, command.getOptionValue('p'));
        if (command.hasOption(OPT_REQUIRE_CERTIFICATE.getOpt())) {
            eperson.setRequireCertificate(Boolean.valueOf(command.getOptionValue(OPT_REQUIRE_CERTIFICATE.getOpt())));
        } else {
            eperson.setRequireCertificate(false);
        }
        try {
            ePersonService.update(context, eperson);
            context.complete();
            System.out.printf("Created EPerson %s\n", eperson.getID().toString());
        }
        catch (SQLException ex) {
            context.abort();
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (AuthorizeException authorizeException) {
            // empty catch block
        }
        return 0;
    }

    private static int cmdDelete(Context context, String[] argv) {
        EPerson eperson;
        block12: {
            CommandLine command;
            Options options = new Options();
            options.addOption(VERB_DELETE);
            OptionGroup identityOptions = new OptionGroup();
            identityOptions.addOption(OPT_EMAIL);
            identityOptions.addOption(OPT_NETID);
            options.addOptionGroup(identityOptions);
            options.addOption("h", "help", false, "explain --delete options");
            GnuParser parser = new GnuParser();
            try {
                command = parser.parse(options, argv);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            if (command.hasOption('h')) {
                new HelpFormatter().printHelp("user --delete [options]", options);
                return 0;
            }
            eperson = null;
            try {
                if (command.hasOption(OPT_NETID.getOpt())) {
                    eperson = ePersonService.findByNetid(context, command.getOptionValue(OPT_NETID.getOpt()));
                    break block12;
                }
                if (command.hasOption(OPT_EMAIL.getOpt())) {
                    eperson = ePersonService.findByEmail(context, command.getOptionValue(OPT_EMAIL.getOpt()));
                    break block12;
                }
                System.err.println("You must specify the user's email address or netid.");
                return 1;
            }
            catch (SQLException e) {
                System.err.append(e.getMessage());
                return 1;
            }
        }
        if (null == eperson) {
            System.err.println("No such EPerson");
            return 1;
        }
        try {
            ePersonService.delete(context, eperson);
            context.complete();
            System.out.printf("Deleted EPerson %s\n", eperson.getID().toString());
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (AuthorizeException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    private static int cmdModify(Context context, String[] argv) throws AuthorizeException, SQLException {
        EPerson eperson;
        CommandLine command;
        block21: {
            Options options = new Options();
            options.addOption(VERB_MODIFY);
            OptionGroup identityOptions = new OptionGroup();
            identityOptions.addOption(OPT_EMAIL);
            identityOptions.addOption(OPT_NETID);
            options.addOptionGroup(identityOptions);
            options.addOption(OPT_GIVENNAME);
            options.addOption(OPT_SURNAME);
            options.addOption(OPT_PHONE);
            options.addOption(OPT_LANGUAGE);
            options.addOption(OPT_REQUIRE_CERTIFICATE);
            options.addOption(OPT_CAN_LOGIN);
            options.addOption(OPT_NEW_EMAIL);
            options.addOption(OPT_NEW_NETID);
            options.addOption("h", "help", false, "explain --modify options");
            GnuParser parser = new GnuParser();
            try {
                command = parser.parse(options, argv);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            if (command.hasOption('h')) {
                new HelpFormatter().printHelp("user --modify [options]", options);
                return 0;
            }
            eperson = null;
            try {
                if (command.hasOption(OPT_NETID.getOpt())) {
                    eperson = ePersonService.findByNetid(context, command.getOptionValue(OPT_NETID.getOpt()));
                    break block21;
                }
                if (command.hasOption(OPT_EMAIL.getOpt())) {
                    eperson = ePersonService.findByEmail(context, command.getOptionValue(OPT_EMAIL.getOpt()));
                    break block21;
                }
                System.err.println("No EPerson selected");
                return 1;
            }
            catch (SQLException e) {
                System.err.append(e.getMessage());
                return 1;
            }
        }
        boolean modified = false;
        if (null == eperson) {
            System.err.println("No such EPerson");
            return 1;
        }
        if (command.hasOption(OPT_NEW_EMAIL.getOpt())) {
            eperson.setEmail(command.getOptionValue(OPT_NEW_EMAIL.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_NEW_NETID.getOpt())) {
            eperson.setNetid(command.getOptionValue(OPT_NEW_NETID.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_GIVENNAME.getOpt())) {
            eperson.setFirstName(context, command.getOptionValue(OPT_GIVENNAME.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_SURNAME.getOpt())) {
            eperson.setLastName(context, command.getOptionValue(OPT_SURNAME.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_PHONE.getOpt())) {
            ePersonService.setMetadata(context, eperson, "phone", command.getOptionValue(OPT_PHONE.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_LANGUAGE.getOpt())) {
            eperson.setLanguage(context, command.getOptionValue(OPT_LANGUAGE.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_REQUIRE_CERTIFICATE.getOpt())) {
            eperson.setRequireCertificate(Boolean.valueOf(command.getOptionValue(OPT_REQUIRE_CERTIFICATE.getOpt())));
            modified = true;
        }
        if (command.hasOption(OPT_CAN_LOGIN.getOpt())) {
            eperson.setCanLogIn(Boolean.valueOf(command.getOptionValue(OPT_CAN_LOGIN.getOpt())));
            modified = true;
        }
        if (modified) {
            try {
                ePersonService.update(context, eperson);
                context.complete();
                System.out.printf("Modified EPerson %s\n", eperson.getID().toString());
            }
            catch (SQLException ex) {
                context.abort();
                System.err.println(ex.getMessage());
                return 1;
            }
            catch (AuthorizeException authorizeException) {}
        } else {
            System.out.println("No changes.");
        }
        return 0;
    }

    private static int cmdList(Context context, String[] argv) {
        try {
            for (EPerson person : ePersonService.findAll(context, 1)) {
                System.out.printf("%s\t%s/%s\t%s, %s\n", person.getID().toString(), person.getEmail(), person.getNetid(), person.getLastName(), person.getFirstName());
            }
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }
}

