/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class ConsumerProfile {
    private static Logger log = LogManager.getLogger(ConsumerProfile.class);
    private String name;
    private Consumer consumer;
    private List<int[]> filters;
    private static final String CONSUMER_PREFIX = "event.consumer.";

    private ConsumerProfile(String name) {
        this.name = name;
    }

    public static ConsumerProfile makeConsumerProfile(String name) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ConsumerProfile result = new ConsumerProfile(name);
        result.readConfiguration();
        return result;
    }

    private void readConfiguration() throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = ConfigurationManager.getProperty(CONSUMER_PREFIX + this.name + ".class");
        String filterString = ConfigurationManager.getProperty(CONSUMER_PREFIX + this.name + ".filters");
        if (className == null) {
            throw new IllegalArgumentException("No class configured for consumer named: " + this.name);
        }
        if (filterString == null) {
            throw new IllegalArgumentException("No filters configured for consumer named: " + this.name);
        }
        this.consumer = (Consumer)Class.forName(className.trim()).newInstance();
        this.filters = new ArrayList<int[]>();
        String[] part = filterString.trim().split(":");
        for (int j = 0; j < part.length; ++j) {
            String[] fpart = part[j].split("\\+");
            if (fpart.length != 2) {
                log.error("Bad Filter clause in consumer stanza in Configuration entry for event.consumer." + this.name + ".consumers: " + part[j]);
                continue;
            }
            int[] filter = new int[]{0, 0};
            String[] objectNames = fpart[0].split("\\|");
            for (int k = 0; k < objectNames.length; ++k) {
                int ot = Event.parseObjectType(objectNames[k]);
                if (ot == 0) {
                    log.error("Bad ObjectType in Consumer Stanza in Configuration entry for event.consumer." + this.name + ".consumers: " + objectNames[k]);
                    continue;
                }
                filter[0] = filter[0] | ot;
            }
            String[] eventNames = fpart[1].split("\\|");
            for (int k = 0; k < eventNames.length; ++k) {
                int et = Event.parseEventType(eventNames[k]);
                if (et == 0) {
                    log.error("Bad EventType in Consumer Stanza in Configuration entry for event.consumer." + this.name + ".consumers: " + eventNames[k]);
                    continue;
                }
                filter[1] = filter[1] | et;
            }
            this.filters.add(filter);
        }
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public List<int[]> getFilters() {
        return this.filters;
    }

    public String getName() {
        return this.name;
    }
}

