/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.event.ConsumerProfile;
import org.dspace.event.Dispatcher;
import org.dspace.event.service.EventService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class EventServiceImpl
implements EventService {
    private Logger log = LogManager.getLogger(EventServiceImpl.class);
    protected DispatcherPoolFactory dispatcherFactory = null;
    protected GenericKeyedObjectPoolConfig poolConfig = null;
    protected KeyedObjectPool dispatcherPool = null;
    protected Map<String, Integer> consumerIndicies = null;
    protected String CONSUMER_PFX = "event.consumer";
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    protected EventServiceImpl() {
        this.initPool();
        this.log.info("EventService dispatcher pool initialized");
    }

    private void initPool() {
        if (this.dispatcherPool == null) {
            this.poolConfig = new GenericKeyedObjectPoolConfig();
            this.poolConfig.setMaxTotalPerKey(100);
            this.poolConfig.setMaxIdlePerKey(5);
            this.poolConfig.setMaxTotal(100);
            try {
                this.dispatcherFactory = new DispatcherPoolFactory();
                this.dispatcherPool = PoolUtils.synchronizedPool((KeyedObjectPool)new GenericKeyedObjectPool((KeyedPooledObjectFactory)this.dispatcherFactory, this.poolConfig));
                this.enumerateConsumers();
            }
            catch (Exception e) {
                this.log.error("Could not initialize EventService dispatcher pool", (Throwable)e);
            }
        }
    }

    @Override
    public Dispatcher getDispatcher(String name) {
        if (this.dispatcherPool == null) {
            this.initPool();
        }
        if (name == null) {
            name = "default";
        }
        try {
            return (Dispatcher)this.dispatcherPool.borrowObject((Object)name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to aquire dispatcher named " + name, e);
        }
    }

    @Override
    public void returnDispatcher(String key, Dispatcher disp) {
        try {
            this.dispatcherPool.returnObject((Object)key, (Object)disp);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to return dispatcher named " + key, e);
        }
    }

    @Override
    public int getConsumerIndex(String consumerClass) {
        Integer index = this.consumerIndicies.get(consumerClass);
        return index != null ? index : -1;
    }

    protected void enumerateConsumers() {
        List propertyNames = configurationService.getPropertyKeys(this.CONSUMER_PFX);
        int bitSetIndex = 0;
        if (this.consumerIndicies == null) {
            this.consumerIndicies = new HashMap<String, Integer>();
        }
        for (String ckey : propertyNames) {
            if (!ckey.endsWith(".class")) continue;
            String consumerName = ckey.substring(this.CONSUMER_PFX.length() + 1, ckey.length() - 6);
            this.consumerIndicies.put(consumerName, bitSetIndex);
            ++bitSetIndex;
        }
    }

    protected class DispatcherPoolFactory
    implements KeyedPooledObjectFactory<String, Dispatcher> {
        private static final String PROP_PFX = "event.dispatcher";
        protected Map<String, String> dispatchers = new HashMap<String, String>();

        public DispatcherPoolFactory() {
            this.parseEventConfig();
        }

        public PooledObject<Dispatcher> wrap(Dispatcher d) {
            return new DefaultPooledObject((Object)d);
        }

        public PooledObject<Dispatcher> makeObject(String dispatcherName) throws Exception {
            Dispatcher dispatcher = null;
            String dispClass = this.dispatchers.get(dispatcherName);
            if (dispClass != null) {
                try {
                    Class[] argTypes = new Class[]{String.class};
                    Constructor<?> dc = Class.forName(dispClass).getConstructor(argTypes);
                    Object[] args = new Object[]{dispatcherName};
                    dispatcher = (Dispatcher)dc.newInstance(args);
                    String consumerKey = "event.dispatcher." + dispatcherName + ".consumers";
                    Object[] consumers = configurationService.getArrayProperty(consumerKey);
                    if (ArrayUtils.isEmpty((Object[])consumers)) {
                        throw new IllegalStateException("No Configuration entry found for consumer list of event Dispatcher: \"" + consumerKey + "\"");
                    }
                    ConsumerProfile consumerProfile = null;
                    for (Object consumer : consumers) {
                        consumerProfile = ConsumerProfile.makeConsumerProfile((String)consumer);
                        consumerProfile.getConsumer().initialize();
                        dispatcher.addConsumerProfile(consumerProfile);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Constructor not found for event dispatcher=" + dispatcherName, e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Error creating event dispatcher=" + dispatcherName, e);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Dispatcher/Consumer class not found for event dispatcher=" + dispatcherName, e);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Dispatcher/Consumer instantiation failure for event dispatcher=" + dispatcherName, e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Dispatcher/Consumer access failure for event dispatcher=" + dispatcherName, e);
                }
            } else {
                throw new IllegalStateException("Requested Dispatcher Does Not Exist In DSpace Configuration!");
            }
            return this.wrap(dispatcher);
        }

        public void activateObject(String arg0, PooledObject<Dispatcher> arg1) throws Exception {
        }

        public void destroyObject(String key, PooledObject<Dispatcher> pooledDispatcher) throws Exception {
            Context ctx = new Context();
            try {
                Dispatcher dispatcher = (Dispatcher)pooledDispatcher.getObject();
                for (ConsumerProfile cp : dispatcher.getConsumers()) {
                    if (cp == null) continue;
                    cp.getConsumer().finish(ctx);
                }
            }
            catch (Exception e) {
                ctx.abort();
                throw e;
            }
        }

        public void passivateObject(String arg0, PooledObject<Dispatcher> arg1) throws Exception {
        }

        public boolean validateObject(String arg0, PooledObject<Dispatcher> arg1) {
            return false;
        }

        private void parseEventConfig() {
            List propertyNames = configurationService.getPropertyKeys(PROP_PFX);
            for (String ckey : propertyNames) {
                if (!ckey.endsWith(".class")) continue;
                String name = ckey.substring(PROP_PFX.length() + 1, ckey.length() - 6);
                String dispatcherClass = configurationService.getProperty(ckey);
                this.dispatchers.put(name, dispatcherClass);
            }
        }
    }
}

