/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.dspace.checker.CheckerCommand;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.SimpleDispatcher;
import org.dspace.core.Context;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;
import org.dspace.health.md5_collector;

public class ChecksumCheck
extends Check {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run(ReportInfo ri) {
        String ret = "No md5 checks made!";
        Context context = new Context();
        CheckerCommand checker = new CheckerCommand(context);
        Date process_start = Calendar.getInstance().getTime();
        checker.setProcessStartDate(process_start);
        checker.setDispatcher(new SimpleDispatcher(context, process_start, false));
        md5_collector collector = new md5_collector();
        checker.setCollector(collector);
        checker.setReportVerbose(true);
        try {
            checker.process();
            context.complete();
            context = null;
        }
        catch (SQLException e) {
            this.error(e);
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
        if (collector.arr.size() > 0) {
            ret = String.format("Checksum performed on [%d] items:\n", collector.arr.size());
            int ok_items = 0;
            for (MostRecentChecksum bi : collector.arr) {
                if (!ChecksumResultCode.CHECKSUM_MATCH.equals((Object)bi.getChecksumResult().getResultCode())) {
                    ret = ret + String.format("md5 checksum FAILED (%s): %s id: %s bitstream-id: %s\n was: %s\n  is: %s\n", bi.getChecksumResult(), bi.getBitstream().getName(), bi.getBitstream().getInternalId(), bi.getBitstream().getID(), bi.getExpectedChecksum(), bi.getCurrentChecksum());
                    continue;
                }
                ++ok_items;
            }
            ret = ret + String.format("checksum OK for [%d] items\n", ok_items);
        }
        return ret;
    }
}

