/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.DataOutputSpec;
import gr.ekt.bte.core.OutputGenerator;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.Value;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.submit.lookup.SubmissionLookupService;
import org.dspace.submit.lookup.SubmissionLookupUtils;
import org.dspace.submit.util.ItemSubmissionLookupDTO;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceWorkspaceItemOutputGenerator
implements OutputGenerator {
    private static Logger log = LogManager.getLogger(DSpaceWorkspaceItemOutputGenerator.class);
    protected Context context;
    protected String formName;
    protected List<WorkspaceItem> witems;
    protected ItemSubmissionLookupDTO dto;
    protected Collection collection;
    Map<String, String> outputMap;
    protected List<String> extraMetadataToKeep;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected MetadataFieldService metadataFieldService;
    @Autowired(required=true)
    protected MetadataSchemaService metadataSchemaService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;

    public List<String> generateOutput(RecordSet recordSet) {
        log.info("BTE OutputGenerator started. Records to output: " + recordSet.getRecords().size());
        String totalString = "";
        for (Record record : recordSet.getRecords()) {
            totalString = totalString + SubmissionLookupUtils.getPrintableString(record) + "\n";
        }
        log.debug("Records to output:\n" + totalString);
        this.witems = new ArrayList<WorkspaceItem>();
        for (Record rec : recordSet.getRecords()) {
            try {
                WorkspaceItem wi = this.workspaceItemService.create(this.context, this.collection, true);
                this.merge(this.formName, wi.getItem(), rec);
                this.witems.add(wi);
            }
            catch (AuthorizeException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public List<String> generateOutput(RecordSet records, DataOutputSpec spec) {
        return this.generateOutput(records);
    }

    public List<WorkspaceItem> getWitems() {
        return this.witems;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setDto(ItemSubmissionLookupDTO dto) {
        this.dto = dto;
    }

    public void setOutputMap(Map<String, String> outputMap) {
        this.outputMap = new HashMap<String, String>();
        for (String key : outputMap.keySet()) {
            this.outputMap.put(outputMap.get(key), key);
        }
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public void setExtraMetadataToKeep(List<String> extraMetadataToKeep) {
        this.extraMetadataToKeep = extraMetadataToKeep;
    }

    public void merge(String formName, Item item, Record record) {
        try {
            Record itemLookup = record;
            HashSet<String> addedMetadata = new HashSet<String>();
            for (String field : itemLookup.getFields()) {
                List values;
                String metadata = this.getMetadata(formName, itemLookup, field);
                if (StringUtils.isBlank((CharSequence)metadata) || this.itemService.getMetadataByMetadataString(item, metadata).size() != 0 && !addedMetadata.contains(metadata)) continue;
                addedMetadata.add(metadata);
                String[] md = this.splitMetadata(metadata);
                if (!this.isValidMetadata(formName, md) || (values = itemLookup.getValues(field)) == null || values.size() <= 0) continue;
                if (this.isRepeatableMetadata(formName, md)) {
                    for (Value value : values) {
                        String[] splitValue = this.splitValue(value.getAsString());
                        if (splitValue[3] != null) {
                            this.itemService.addMetadata(this.context, item, md[0], md[1], md[2], md[3], splitValue[0], splitValue[1], Integer.parseInt(splitValue[2]));
                            continue;
                        }
                        this.itemService.addMetadata(this.context, item, md[0], md[1], md[2], md[3], value.getAsString());
                    }
                    continue;
                }
                String value = ((Value)values.iterator().next()).getAsString();
                String[] splitValue = this.splitValue(value);
                if (splitValue[3] != null) {
                    this.itemService.addMetadata(this.context, item, md[0], md[1], md[2], md[3], splitValue[0], splitValue[1], Integer.parseInt(splitValue[2]));
                    continue;
                }
                this.itemService.addMetadata(this.context, item, md[0], md[1], md[2], md[3], value);
            }
            this.itemService.update(this.context, item);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (AuthorizeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String getMetadata(String formName, Record itemLookup, String name) {
        String type = SubmissionLookupService.getType(itemLookup);
        String md = this.outputMap.get(type + "." + name);
        if (StringUtils.isBlank((CharSequence)md) && StringUtils.isBlank((CharSequence)(md = this.outputMap.get(formName + "." + name)))) {
            md = this.outputMap.get(name);
        }
        if (md != null && md.contains("|")) {
            String[] cond = md.trim().split("\\|");
            for (int idx = 1; idx < cond.length; ++idx) {
                boolean temp = itemLookup.getFields().contains(cond[idx]);
                if (!temp) continue;
                return null;
            }
            return cond[0];
        }
        return md;
    }

    protected String[] splitMetadata(String metadata) {
        String[] mdSplit = new String[3];
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            String[] tmpSplit = metadata.split("\\.");
            if (tmpSplit.length == 4) {
                mdSplit = new String[]{tmpSplit[0], tmpSplit[1], tmpSplit[2], tmpSplit[3]};
            } else if (tmpSplit.length == 3) {
                mdSplit = new String[]{tmpSplit[0], tmpSplit[1], tmpSplit[2], null};
            } else if (tmpSplit.length == 2) {
                mdSplit = new String[]{tmpSplit[0], tmpSplit[1], null, null};
            }
        }
        return mdSplit;
    }

    protected boolean isValidMetadata(String formName, String[] md) {
        try {
            if (this.extraMetadataToKeep != null && this.extraMetadataToKeep.contains(StringUtils.join((Object[])Arrays.copyOfRange(md, 0, 3), (String)"."))) {
                return true;
            }
            return this.getDCInput(formName, md[0], md[1], md[2]) != null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected DCInput getDCInput(String formName, String schema, String element, String qualifier) throws DCInputsReaderException {
        List<DCInputSet> dcinputsets = new DCInputsReader().getInputsBySubmissionName(formName);
        for (DCInputSet dcinputset : dcinputsets) {
            DCInput[][] dCInputArray = dcinputset.getFields();
            int n = dCInputArray.length;
            for (int i = 0; i < n; ++i) {
                DCInput[] dcrow;
                for (DCInput dcinput : dcrow = dCInputArray[i]) {
                    if (!dcinput.getSchema().equals(schema) || !dcinput.getElement().equals(element) || (dcinput.getQualifier() == null || !dcinput.getQualifier().equals(qualifier)) && (dcinput.getQualifier() != null || qualifier != null)) continue;
                    return dcinput;
                }
            }
        }
        return null;
    }

    protected boolean isRepeatableMetadata(String formName, String[] md) {
        try {
            DCInput dcinput = this.getDCInput(formName, md[0], md[1], md[2]);
            if (dcinput != null) {
                return dcinput.isRepeatable();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String[] splitValue(String value) {
        String[] splitted = value.split("#######");
        String[] result = new String[6];
        result[0] = splitted[0];
        result[2] = "-1";
        result[3] = "-1";
        result[4] = "-1";
        if (splitted.length > 1) {
            result[5] = "splitted";
            if (StringUtils.isNotBlank((CharSequence)splitted[1])) {
                result[1] = splitted[1];
            }
            if (splitted.length > 2) {
                result[2] = String.valueOf(Integer.parseInt(splitted[2]));
                if (splitted.length > 3) {
                    result[3] = String.valueOf(Integer.parseInt(splitted[3]));
                    if (splitted.length > 4) {
                        result[4] = String.valueOf(Integer.parseInt(splitted[4]));
                    }
                }
            }
        }
        return result;
    }

    protected void makeSureMetadataExist(Context context, String schema, String element, String qualifier) {
        try {
            context.turnOffAuthorisationSystem();
            boolean create = false;
            MetadataSchema mdschema = this.metadataSchemaService.find(context, schema);
            MetadataField mdfield = null;
            if (mdschema == null) {
                mdschema = this.metadataSchemaService.create(context, schema, "http://www.dspace.org/sl/" + schema);
                create = true;
            } else {
                mdfield = this.metadataFieldService.findByElement(context, mdschema, element, qualifier);
            }
            if (mdfield == null) {
                this.metadataFieldService.create(context, mdschema, element, qualifier, "Campo utilizzato per la cache del provider submission-lookup: " + schema);
                create = true;
            }
            if (create) {
                context.complete();
            }
            context.restoreAuthSystemState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

