/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.DataLoader;
import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.MalformedSourceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.submit.lookup.NetworkSubmissionLookupDataLoader;
import org.dspace.submit.lookup.SubmissionLookupDataLoader;
import org.dspace.submit.lookup.SubmissionLookupUtils;

public class MultipleSubmissionLookupDataLoader
implements DataLoader {
    private static Logger log = LogManager.getLogger(MultipleSubmissionLookupDataLoader.class);
    protected final String NOT_FOUND_DOI = "NOT-FOUND-DOI";
    Map<String, DataLoader> dataloadersMap;
    Map<String, Set<String>> identifiers = null;
    Map<String, Set<String>> searchTerms = null;
    String filename = null;
    String type = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordSet getRecords() throws MalformedSourceException {
        RecordSet recordSet = new RecordSet();
        for (String providerName : this.filterProviders().keySet()) {
            DataLoader provider = this.dataloadersMap.get(providerName);
            RecordSet subRecordSet = provider.getRecords();
            recordSet.addAll(subRecordSet);
            for (Record record : subRecordSet.getRecords()) {
                if (!record.isMutable()) continue;
                record.makeMutable().addValue("provider_name_field", (Value)new StringValue(providerName));
            }
        }
        if (this.searchTerms != null || this.identifiers != null && !this.identifiers.containsKey("doi")) {
            HashMap<String, HashSet<String>> provider2foundDOIs = new HashMap<String, HashSet<String>>();
            ArrayList<String> foundDOIs = new ArrayList<String>();
            for (Record publication : recordSet.getRecords()) {
                HashSet<String> tmp;
                String providerName = SubmissionLookupUtils.getFirstValue(publication, "provider_name_field");
                String doi = null;
                if (publication.getValues("doi") != null && publication.getValues("doi").size() > 0) {
                    doi = ((Value)publication.getValues("doi").iterator().next()).getAsString();
                }
                if (doi == null) {
                    doi = "NOT-FOUND-DOI";
                    continue;
                }
                if (!foundDOIs.contains(doi = SubmissionLookupUtils.normalizeDOI(doi))) {
                    foundDOIs.add(doi);
                }
                if ((tmp = (HashSet<String>)provider2foundDOIs.get(providerName)) == null) {
                    tmp = new HashSet<String>();
                    provider2foundDOIs.put(providerName, tmp);
                }
                tmp.add(doi);
            }
            for (String providerName : this.dataloadersMap.keySet()) {
                SubmissionLookupDataLoader provider;
                DataLoader genProvider = this.dataloadersMap.get(providerName);
                if (!(genProvider instanceof SubmissionLookupDataLoader) || !(provider = (SubmissionLookupDataLoader)genProvider).getSupportedIdentifiers().contains("doi")) continue;
                HashSet<String> doiToSearch = new HashSet<String>();
                Set alreadyFoundDOIs = (Set)provider2foundDOIs.get(providerName);
                for (String doi : foundDOIs) {
                    if (alreadyFoundDOIs != null && alreadyFoundDOIs.contains(doi)) continue;
                    doiToSearch.add(doi);
                }
                List<Record> pPublications = null;
                Context context = null;
                try {
                    if (doiToSearch.size() > 0) {
                        context = new Context();
                        pPublications = provider.getByDOIs(context, doiToSearch);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (context != null && context.isValid()) {
                        context.abort();
                    }
                }
                if (pPublications == null) continue;
                for (Record rec : pPublications) {
                    recordSet.addRecord(rec);
                    if (!rec.isMutable()) continue;
                    rec.makeMutable().addValue("provider_name_field", (Value)new StringValue(providerName));
                }
            }
        }
        log.info("BTE DataLoader finished. Items loaded: " + recordSet.getRecords().size());
        String totalString = "";
        for (Record record : recordSet.getRecords()) {
            totalString = totalString + SubmissionLookupUtils.getPrintableString(record) + "\n";
        }
        log.debug("Records loaded:\n" + totalString);
        return recordSet;
    }

    public RecordSet getRecords(DataLoadingSpec loadingSpec) throws MalformedSourceException {
        if (loadingSpec.getOffset() > 0) {
            return new RecordSet();
        }
        return this.getRecords();
    }

    public Map<String, DataLoader> getProvidersMap() {
        return this.dataloadersMap;
    }

    public void setDataloadersMap(Map<String, DataLoader> providersMap) {
        this.dataloadersMap = providersMap;
    }

    public void setIdentifiers(Map<String, Set<String>> identifiers) {
        this.identifiers = identifiers;
        this.filename = null;
        this.searchTerms = null;
        if (this.dataloadersMap != null) {
            for (String providerName : this.dataloadersMap.keySet()) {
                DataLoader provider = this.dataloadersMap.get(providerName);
                if (!(provider instanceof NetworkSubmissionLookupDataLoader)) continue;
                ((NetworkSubmissionLookupDataLoader)provider).setIdentifiers(identifiers);
            }
        }
    }

    public void setSearchTerms(Map<String, Set<String>> searchTerms) {
        this.searchTerms = searchTerms;
        this.identifiers = null;
        this.filename = null;
        if (this.dataloadersMap != null) {
            for (String providerName : this.dataloadersMap.keySet()) {
                DataLoader provider = this.dataloadersMap.get(providerName);
                if (!(provider instanceof NetworkSubmissionLookupDataLoader)) continue;
                ((NetworkSubmissionLookupDataLoader)provider).setSearchTerms(searchTerms);
            }
        }
    }

    public void setFile(String filename, String type) {
        this.filename = filename;
        this.type = type;
        this.identifiers = null;
        this.searchTerms = null;
        if (this.dataloadersMap != null) {
            for (String providerName : this.dataloadersMap.keySet()) {
                DataLoader provider = this.dataloadersMap.get(providerName);
                if (!(provider instanceof FileDataLoader)) continue;
                ((FileDataLoader)provider).setFilename(filename);
            }
        }
    }

    public Map<String, DataLoader> filterProviders() {
        HashMap<String, DataLoader> result = new HashMap<String, DataLoader>();
        for (String providerName : this.dataloadersMap.keySet()) {
            DataLoader dataLoader = this.dataloadersMap.get(providerName);
            if (this.searchTerms != null && this.identifiers == null && this.filename == null) {
                if (!(dataLoader instanceof SubmissionLookupDataLoader) || !((SubmissionLookupDataLoader)dataLoader).isSearchProvider()) continue;
                result.put(providerName, dataLoader);
                continue;
            }
            if (this.searchTerms == null && this.identifiers != null && this.filename == null) {
                if (!(dataLoader instanceof SubmissionLookupDataLoader)) continue;
                result.put(providerName, dataLoader);
                continue;
            }
            if (this.searchTerms != null || this.identifiers != null || this.filename == null || !(dataLoader instanceof FileDataLoader) || !providerName.endsWith(this.type)) continue;
            result.put(providerName, dataLoader);
        }
        return result;
    }
}

