/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.DataLoader;
import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.exceptions.MalformedSourceException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.submit.lookup.SubmissionLookupUtils;
import org.dspace.submit.util.ItemSubmissionLookupDTO;

public class SubmissionItemDataLoader
implements DataLoader {
    protected List<ItemSubmissionLookupDTO> dtoList = null;
    List<DataLoader> providers = null;
    private static Logger log = LogManager.getLogger(SubmissionItemDataLoader.class);

    public RecordSet getRecords() throws MalformedSourceException {
        if (this.dtoList == null) {
            throw new MalformedSourceException("dtoList not initialized");
        }
        RecordSet ret = new RecordSet();
        for (ItemSubmissionLookupDTO dto : this.dtoList) {
            Record rec = dto.getTotalPublication(this.providers);
            ret.addRecord(rec);
        }
        log.info("BTE DataLoader finished. Items loaded: " + ret.getRecords().size());
        String totalString = "";
        for (Record record : ret.getRecords()) {
            totalString = totalString + SubmissionLookupUtils.getPrintableString(record) + "\n";
        }
        log.debug("Records loaded:\n" + totalString);
        return ret;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        if (spec.getOffset() > 0) {
            return new RecordSet();
        }
        return this.getRecords();
    }

    public List<ItemSubmissionLookupDTO> getDtoList() {
        return this.dtoList;
    }

    public void setDtoList(List<ItemSubmissionLookupDTO> dtoList) {
        this.dtoList = dtoList;
    }

    public List<DataLoader> getProviders() {
        return this.providers;
    }

    public void setProviders(List<DataLoader> providers) {
        this.providers = providers;
    }
}

