/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.sql.SQLException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;

@Entity
@Table(name="workflowitem")
public class BasicWorkflowItem
implements WorkflowItem {
    @Id
    @Column(name="workflow_id", unique=true, nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="workflowitem_seq")
    @SequenceGenerator(name="workflowitem_seq", sequenceName="workflowitem_seq", allocationSize=1)
    private Integer workflowitemId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id", unique=true)
    private Item item;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="collection_id")
    private Collection collection;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner")
    private EPerson owner;
    @Column(name="state")
    private int state;
    @Column(name="multiple_titles")
    private boolean multipleTitles = false;
    @Column(name="published_before")
    private boolean publishedBefore = false;
    @Column(name="multiple_files")
    private boolean multipleFiles = false;

    protected BasicWorkflowItem() {
    }

    @Override
    public Integer getID() {
        return this.workflowitemId;
    }

    public EPerson getOwner() {
        return this.owner;
    }

    public void setOwner(EPerson ep) {
        this.owner = ep;
    }

    @Override
    public int getState() {
        return this.state;
    }

    public void setState(int newstate) {
        this.state = newstate;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    void setItem(Item item) {
        this.item = item;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    @Override
    public EPerson getSubmitter() throws SQLException {
        return this.item.getSubmitter();
    }

    @Override
    public boolean hasMultipleFiles() {
        return this.multipleFiles;
    }

    @Override
    public void setMultipleFiles(boolean b) {
        this.multipleFiles = b;
    }

    @Override
    public boolean hasMultipleTitles() {
        return this.multipleTitles;
    }

    @Override
    public void setMultipleTitles(boolean b) {
        this.multipleTitles = b;
    }

    @Override
    public boolean isPublishedBefore() {
        return this.publishedBefore;
    }

    @Override
    public void setPublishedBefore(boolean b) {
        this.publishedBefore = b;
    }

    @Override
    public int getType() {
        return 9;
    }
}

