/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.v2.SHERPAPublisherResponse;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.utils.DSpace;

public class SHERPARoMEOPublisher
implements ChoiceAuthority {
    private String pluginInstanceName;

    @Override
    public Choices getMatches(String text, int start, int limit, String locale) {
        Choices result;
        if (text == null || text.trim().length() == 0) {
            return new Choices(true);
        }
        SHERPAService sherpaService = (SHERPAService)new DSpace().getSingletonService(SHERPAService.class);
        SHERPAPublisherResponse sherpaResponse = sherpaService.performPublisherRequest("publisher", "name", "contains word", text, 0, 0);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getPublishers())) {
            int total;
            List<Choice> list = sherpaResponse.getPublishers().stream().skip(start).limit(limit).map(sherpaPublisher -> new Choice(sherpaPublisher.getIdentifier(), sherpaPublisher.getName(), sherpaPublisher.getName())).collect(Collectors.toList());
            result = new Choices(list.toArray(new Choice[list.size()]), start, total, 600, (total = sherpaResponse.getPublishers().size()) > start + limit);
        } else {
            result = new Choices(false);
        }
        return result;
    }

    @Override
    public Choices getBestMatch(String text, String locale) {
        return this.getMatches(text, 0, 1, locale);
    }

    @Override
    public String getLabel(String key, String locale) {
        SHERPAService sherpaService = (SHERPAService)new DSpace().getSingletonService(SHERPAService.class);
        SHERPAPublisherResponse sherpaResponse = sherpaService.performPublisherRequest("publisher", "id", "equals", key, 0, 1);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getPublishers())) {
            return sherpaResponse.getPublishers().get(0).getName();
        }
        return null;
    }

    @Override
    public void setPluginInstanceName(String name) {
        this.pluginInstanceName = name;
    }

    @Override
    public String getPluginInstanceName() {
        return this.pluginInstanceName;
    }
}

