/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.NameAwarePlugin;
import org.dspace.core.PathsClassLoader;
import org.dspace.core.PluginConfigurationError;
import org.dspace.core.PluginInstantiationException;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class LegacyPluginServiceImpl
implements PluginService {
    private static final Logger log = LogManager.getLogger(LegacyPluginServiceImpl.class);
    private static final String SINGLE_PREFIX = "plugin.single.";
    private static final String SEQUENCE_PREFIX = "plugin.sequence.";
    private static final String NAMED_PREFIX = "plugin.named.";
    private static final String SELFNAMED_PREFIX = "plugin.selfnamed.";
    private static final String CLASSPATH = "plugin.classpath";
    private static final String SEP = "\u001c";
    private String[] classPath;
    private PathsClassLoader loader;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    private Map<String, String> namedPluginClasses = new HashMap<String, String>();
    private Map<Serializable, Object> namedInstanceCache = new HashMap<Serializable, Object>();

    protected LegacyPluginServiceImpl() {
    }

    void init() {
        String path = this.configurationService.getProperty(CLASSPATH);
        this.classPath = null == path ? new String[0] : path.split(":");
        this.loader = new PathsClassLoader(LegacyPluginServiceImpl.class.getClassLoader(), this.classPath);
    }

    @Override
    public Object getSinglePlugin(Class interfaceClass) throws PluginConfigurationError, PluginInstantiationException {
        String iname = interfaceClass.getName();
        String key = SINGLE_PREFIX + iname;
        String classname = this.configurationService.getProperty(key);
        if (classname != null) {
            return this.getAnonymousPlugin(classname.trim());
        }
        throw new PluginConfigurationError("No Single Plugin configured for interface \"" + iname + "\"");
    }

    @Override
    public Object[] getPluginSequence(Class interfaceClass) throws PluginInstantiationException {
        HashMap<String, String[]> sequenceConfig = new HashMap<String, String[]>();
        String iname = interfaceClass.getName();
        String[] classname = null;
        if (!sequenceConfig.containsKey(iname)) {
            String key = SEQUENCE_PREFIX + iname;
            classname = this.configurationService.getArrayProperty(key);
            if (classname == null || classname.length == 0) {
                log.warn("No Configuration entry found for Sequence Plugin interface=" + iname);
                return (Object[])Array.newInstance(interfaceClass, 0);
            }
            sequenceConfig.put(iname, classname);
        } else {
            classname = (String[])sequenceConfig.get(iname);
        }
        Object[] result = (Object[])Array.newInstance(interfaceClass, classname.length);
        for (int i = 0; i < classname.length; ++i) {
            log.debug("Adding Sequence plugin for interface= " + iname + ", class=" + classname[i]);
            result[i] = this.getAnonymousPlugin(classname[i]);
        }
        return result;
    }

    private Object getAnonymousPlugin(String classname) throws PluginInstantiationException {
        try {
            Class<?> pluginClass = Class.forName(classname, true, this.loader);
            return pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException("Cannot load plugin class: " + e.toString(), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new PluginInstantiationException(e);
        }
    }

    private void configureNamedPlugin(String iname) throws ClassNotFoundException {
        int found = 0;
        if (!this.namedPluginClasses.containsKey(iname)) {
            String[] selfNamedVals;
            String key = NAMED_PREFIX + iname;
            String[] namedVals = this.configurationService.getArrayProperty(key);
            if (namedVals != null && namedVals.length > 0) {
                String prevClassName = null;
                for (String namedVal : namedVals) {
                    String[] valSplit = namedVal.trim().split("\\s*=\\s*");
                    String className = null;
                    String name = null;
                    if (prevClassName != null && valSplit.length == 1) {
                        className = prevClassName;
                        name = valSplit[0];
                    } else {
                        prevClassName = className = valSplit[0];
                        name = valSplit[1];
                    }
                    String[] names = name.trim().split("\\s*,\\s*");
                    found += this.installNamedConfigs(iname, className, names);
                }
            }
            if ((selfNamedVals = this.configurationService.getArrayProperty(key = SELFNAMED_PREFIX + iname)) != null && selfNamedVals.length > 0) {
                for (String classname : selfNamedVals) {
                    try {
                        Class<?> pluginClass = Class.forName(classname, true, this.loader);
                        String[] names = (String[])pluginClass.getMethod("getPluginNames", new Class[0]).invoke(null, new Object[0]);
                        if (names == null || names.length == 0) {
                            log.error("Self-named plugin class \"" + classname + "\" returned null or empty name list!");
                            continue;
                        }
                        found += this.installNamedConfigs(iname, classname, names);
                    }
                    catch (NoSuchMethodException e) {
                        log.error("Implementation Class \"" + classname + "\" is not a subclass of SelfNamedPlugin, it has no getPluginNames() method.");
                    }
                    catch (Exception e) {
                        log.error("Error while configuring self-named plugin", (Throwable)e);
                    }
                }
            }
            this.namedPluginClasses.put(iname, "org.dspace.core.marker");
            if (found == 0) {
                log.error("No named plugins found for interface=" + iname);
            }
        }
    }

    private int installNamedConfigs(String iname, String classname, String[] names) throws ClassNotFoundException {
        int found = 0;
        for (int i = 0; i < names.length; ++i) {
            String key = iname + SEP + names[i];
            if (this.namedPluginClasses.containsKey(key)) {
                log.error("Name collision in named plugin, implementation class=\"" + classname + "\", name=\"" + names[i] + "\"");
            } else {
                this.namedPluginClasses.put(key, classname);
            }
            log.debug("Got Named Plugin, intfc=" + iname + ", name=" + names[i] + ", class=" + classname);
            ++found;
        }
        return found;
    }

    @Override
    public Object getNamedPlugin(Class interfaceClass, String name) throws PluginInstantiationException {
        try {
            String iname = interfaceClass.getName();
            this.configureNamedPlugin(iname);
            String key = iname + SEP + name;
            String cname = this.namedPluginClasses.get(key);
            if (cname != null) {
                Class<?> pluginClass = Class.forName(cname, true, this.loader);
                log.debug("Creating instance of: " + cname + " for interface=" + iname + " pluginName=" + name);
                Object result = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (result instanceof NameAwarePlugin) {
                    ((NameAwarePlugin)result).setPluginInstanceName(name);
                }
                return result;
            }
            log.warn("Cannot find named plugin for interface=" + iname + ", name=\"" + name + "\"");
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException("Cannot load plugin class: " + e.toString(), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new PluginInstantiationException(e);
        }
        return null;
    }

    @Override
    public void clearNamedPluginClasses() {
        this.namedPluginClasses.clear();
    }

    @Override
    public boolean hasNamedPlugin(Class interfaceClass, String name) throws PluginInstantiationException {
        try {
            String iname = interfaceClass.getName();
            this.configureNamedPlugin(iname);
            String key = iname + SEP + name;
            return this.namedPluginClasses.get(key) != null;
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException("Cannot load plugin class: " + e.toString(), e);
        }
    }

    @Override
    public String[] getAllPluginNames(Class interfaceClass) {
        try {
            String iname = interfaceClass.getName();
            this.configureNamedPlugin(iname);
            String prefix = iname + SEP;
            ArrayList<String> result = new ArrayList<String>();
            for (String key : this.namedPluginClasses.keySet()) {
                if (!key.startsWith(prefix)) continue;
                result.add(key.substring(prefix.length()));
            }
            if (result.size() == 0) {
                log.error("Cannot find any names for named plugin, interface=" + iname);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (ClassNotFoundException e) {
            return new String[0];
        }
    }

    private boolean checkClassname(String iname, String msg) {
        try {
            if (Class.forName(iname, true, this.loader) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException ce) {
            log.error("No class definition found for " + msg + ": \"" + iname + "\"");
        }
        return false;
    }

    private boolean checkSelfNamed(String iname) {
        try {
            if (!this.checkSelfNamed(Class.forName(iname, true, this.loader))) {
                log.error("The class \"" + iname + "\" is NOT a subclass of SelfNamedPlugin but it should be!");
            }
        }
        catch (ClassNotFoundException ce) {
            log.error("No class definition found for self-named class interface: \"" + iname + "\"");
        }
        return false;
    }

    private boolean checkSelfNamed(Class cls) {
        Class sup = cls.getSuperclass();
        if (sup == null) {
            return false;
        }
        if (sup.equals(SelfNamedPlugin.class)) {
            return true;
        }
        return this.checkSelfNamed(sup);
    }

    private void checkNames(String iname) {
        try {
            this.configureNamedPlugin(iname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void checkConfiguration() throws IOException {
        String[] vals;
        Object fr = null;
        Object cr = null;
        HashMap<String, String> singleKey = new HashMap<String, String>();
        HashMap<String, String> sequenceKey = new HashMap<String, String>();
        HashMap<String, String> namedKey = new HashMap<String, String>();
        HashMap<String, String> selfnamedKey = new HashMap<String, String>();
        List keys = this.configurationService.getPropertyKeys("plugin.");
        for (String key : keys) {
            if (key.startsWith(SINGLE_PREFIX)) {
                singleKey.put(key.substring(SINGLE_PREFIX.length()), key);
                continue;
            }
            if (key.startsWith(SEQUENCE_PREFIX)) {
                sequenceKey.put(key.substring(SEQUENCE_PREFIX.length()), key);
                continue;
            }
            if (key.startsWith(NAMED_PREFIX)) {
                namedKey.put(key.substring(NAMED_PREFIX.length()), key);
                continue;
            }
            if (key.startsWith(SELFNAMED_PREFIX)) {
                selfnamedKey.put(key.substring(SELFNAMED_PREFIX.length()), key);
                continue;
            }
            log.error("Key with unknown prefix \"" + key + "\" in DSpace configuration");
        }
        ArrayList allInterfaces = new ArrayList();
        allInterfaces.addAll(singleKey.keySet());
        allInterfaces.addAll(sequenceKey.keySet());
        allInterfaces.addAll(namedKey.keySet());
        allInterfaces.addAll(selfnamedKey.keySet());
        Iterator<Object> ii = allInterfaces.iterator();
        while (ii.hasNext()) {
            this.checkClassname((String)ii.next(), "key interface or class");
        }
        HashMap<String, String> allImpls = new HashMap<String, String>();
        for (String key : singleKey.keySet()) {
            String val = this.configurationService.getProperty(SINGLE_PREFIX + key);
            if (val == null) {
                log.error("Single plugin config not found for: plugin.single." + key);
                continue;
            }
            if (!this.checkClassname(val = val.trim(), "implementation class")) continue;
            allImpls.put(val, val);
        }
        for (String key : sequenceKey.keySet()) {
            vals = this.configurationService.getArrayProperty(SEQUENCE_PREFIX + key);
            if (vals == null || vals.length == 0) {
                log.error("Sequence plugin config not found for: plugin.sequence." + key);
                continue;
            }
            for (String val : vals) {
                if (!this.checkClassname(val, "implementation class")) continue;
                allImpls.put(val, val);
            }
        }
        for (String key : selfnamedKey.keySet()) {
            vals = this.configurationService.getArrayProperty(SELFNAMED_PREFIX + key);
            if (vals == null || vals.length == 0) {
                log.error("Selfnamed plugin config not found for: plugin.selfnamed." + key);
                continue;
            }
            for (String val : vals) {
                if (!this.checkClassname(val, "selfnamed implementation class")) continue;
                allImpls.put(val, val);
                this.checkSelfNamed(val);
            }
            this.checkNames(key);
        }
        for (String key : namedKey.keySet()) {
            vals = this.configurationService.getArrayProperty(NAMED_PREFIX + key);
            if (vals == null || vals.length == 0) {
                log.error("Named plugin config not found for: plugin.named." + key);
                continue;
            }
            this.checkNames(key);
            for (String val : vals) {
                String[] val_split = val.split("\\s*=\\s*");
                String classname = val_split[0];
                if (!this.checkClassname(classname, "implementation class")) continue;
                allImpls.put(classname, classname);
            }
        }
    }

    public void main(String[] argv) throws Exception {
        this.checkConfiguration();
    }
}

