/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.migration.SubmissionFormsMigrationCliScriptConfiguration;
import org.dspace.utils.DSpace;

public class SubmissionFormsMigration
extends DSpaceRunnable<SubmissionFormsMigrationCliScriptConfiguration> {
    private boolean help = false;
    private String inputFormsFilePath = null;
    private String itemSubmissionsFilePath = null;
    private static final String PATH_OUT_CONFIG = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config";
    private static final String PATH_XSL_SUBMISSION_FORMS = PATH_OUT_CONFIG + File.separator + "migration" + File.separator + "submission-forms.xsl";
    private static final String PATH_XSL_ITEM_SUBMISSION = PATH_OUT_CONFIG + File.separator + "migration" + File.separator + "item-submissions.xsl";
    private static final String PATH_OUT_INPUT_FORMS = PATH_OUT_CONFIG + File.separator + "submission-forms.xml.migrated";
    private static final String PATH_OUT_ITEM_SUBMISSION = PATH_OUT_CONFIG + File.separator + "item-submission.xml.migrated";
    private static final String NAME_DTD_INPUT_FORMS = "input-forms.dtd";
    private static final String NAME_DTD_ITEM_SUBMISSION = "item-submission.dtd";
    private static final String CONTENT_DTD_ITEM_SUBMISSION_DUMMY = "<!ELEMENT item-submission (submission-map, step-definitions, submission-definitions) >";
    private static final String CONTENT_DTD_INPUT_FORMS_DUMMY = "<!ELEMENT input-forms (form-map, form-definitions, form-value-pairs) >";
    private List<File> tempFiles = new ArrayList<File>();
    private static final String TRANSFORMER_FACTORY_CLASS = "org.apache.xalan.processor.TransformerFactoryImpl";

    @Override
    public void internalRun() throws TransformerException {
        if (this.help) {
            this.printHelp();
            return;
        }
        if (this.inputFormsFilePath != null) {
            this.transform(this.inputFormsFilePath, PATH_XSL_SUBMISSION_FORMS, PATH_OUT_INPUT_FORMS);
        }
        if (this.itemSubmissionsFilePath != null) {
            this.transform(this.itemSubmissionsFilePath, PATH_XSL_ITEM_SUBMISSION, PATH_OUT_ITEM_SUBMISSION);
        }
        this.deleteTempFiles();
    }

    private void transform(String sourceFilePath, String xsltFilePath, String outputPath) throws TransformerException {
        Transformer trans;
        this.handler.logInfo("Transforming " + sourceFilePath + " with xsl: " + xsltFilePath + " to output: " + outputPath);
        StreamSource xmlSource = new StreamSource(new File(sourceFilePath));
        StreamSource xsltSource = new StreamSource(new File(xsltFilePath));
        StreamResult result = new StreamResult(new File(outputPath));
        TransformerFactory transformerFactory = TransformerFactory.newInstance(TRANSFORMER_FACTORY_CLASS, null);
        try {
            trans = transformerFactory.newTransformer(xsltSource);
            trans.setParameter("inputFormsPath", this.inputFormsFilePath);
        }
        catch (TransformerConfigurationException e) {
            this.handler.logError("Error: the stylesheet at '" + xsltFilePath + "' couldn't be used");
            throw e;
        }
        try {
            trans.transform(xmlSource, result);
        }
        catch (Throwable t) {
            this.handler.logError("Error: couldn't convert the metadata file at '" + sourceFilePath);
            throw t;
        }
    }

    @Override
    public void setup() throws ParseException {
        if (this.commandLine.hasOption('h')) {
            this.help = true;
            return;
        }
        if (this.commandLine.hasOption('f')) {
            this.inputFormsFilePath = this.commandLine.getOptionValue('f');
            this.checkIfValidXMLFile(this.inputFormsFilePath);
            this.inputFormsFilePath = this.getAbsolutePath(this.inputFormsFilePath);
        }
        if (this.commandLine.hasOption('s')) {
            this.itemSubmissionsFilePath = this.commandLine.getOptionValue('s');
            this.checkIfValidXMLFile(this.itemSubmissionsFilePath);
            this.itemSubmissionsFilePath = this.getAbsolutePath(this.itemSubmissionsFilePath);
        }
        if (!this.commandLine.hasOption('s') || !this.commandLine.hasOption('f')) {
            this.throwParseException("Please fill in both -f <source-input-forms-path> and -s <source-item-submissions-path>");
        }
        this.createDTDFileDummiesIfNotPresent();
    }

    private String getAbsolutePath(String relativePath) {
        File file = new File(relativePath);
        return file.getAbsolutePath();
    }

    private void createDTDFileDummiesIfNotPresent() {
        this.createDummyFileIfNotPresent(this.itemSubmissionsFilePath, NAME_DTD_ITEM_SUBMISSION, CONTENT_DTD_ITEM_SUBMISSION_DUMMY);
        this.createDummyFileIfNotPresent(this.inputFormsFilePath, NAME_DTD_INPUT_FORMS, CONTENT_DTD_INPUT_FORMS_DUMMY);
    }

    private void createDummyFileIfNotPresent(String fileInInputDir, String dummyFileName, String dummyContent) {
        String dir = StringUtils.substringBeforeLast((String)fileInInputDir, (String)File.separator);
        File dummyFile = new File(dir + File.separator + dummyFileName);
        if (!dummyFile.isFile()) {
            Path path = Paths.get(dir + File.separator + dummyFileName, new String[0]);
            byte[] strToBytes = dummyContent.getBytes();
            try {
                Files.write(path, strToBytes, new OpenOption[0]);
            }
            catch (IOException e) {
                this.handler.logError("Error trying to create dummy " + dummyFileName);
            }
            this.tempFiles.add(dummyFile);
        }
    }

    private void deleteTempFiles() {
        for (File tempFile : this.tempFiles) {
            if (tempFile == null || !tempFile.isFile()) continue;
            tempFile.delete();
        }
    }

    private void checkIfValidXMLFile(String filePath) throws ParseException {
        File file = new File(filePath);
        if (!file.exists()) {
            this.throwParseException("There is no file at path: " + filePath);
        }
        if (!file.isFile() && file.isDirectory()) {
            this.throwParseException("This is a dir, not a file: " + filePath);
        }
        if (!file.getName().endsWith(".xml")) {
            this.throwParseException("This is not an XML file (doesn't end in .xml): " + filePath);
        }
    }

    private void throwParseException(String message) throws ParseException {
        this.handler.logError(message);
        throw new ParseException(message);
    }

    @Override
    public SubmissionFormsMigrationCliScriptConfiguration getScriptConfiguration() {
        return (SubmissionFormsMigrationCliScriptConfiguration)new DSpace().getServiceManager().getServiceByName("submission-forms-migrate", SubmissionFormsMigrationCliScriptConfiguration.class);
    }
}

