/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestItemMetadataStrategy
extends RequestItemSubmitterStrategy {
    protected String emailMetadata;
    protected String fullNameMetadata;
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    public RequestItemAuthor getRequestItemAuthor(Context context, Item item) throws SQLException {
        RequestItemAuthor author = null;
        if (this.emailMetadata != null) {
            List<MetadataValue> vals = this.itemService.getMetadataByMetadataString(item, this.emailMetadata);
            if (vals.size() > 0) {
                List<MetadataValue> nameVals;
                String email = vals.iterator().next().getValue();
                String fullname = null;
                if (this.fullNameMetadata != null && (nameVals = this.itemService.getMetadataByMetadataString(item, this.fullNameMetadata)).size() > 0) {
                    fullname = nameVals.iterator().next().getValue();
                }
                if (StringUtils.isBlank(fullname)) {
                    fullname = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemMetadataStrategy.unnamed", context);
                }
                author = new RequestItemAuthor(fullname, email);
                return author;
            }
        } else {
            author = super.getRequestItemAuthor(context, item);
            if (null == author || null == author.getEmail()) {
                String email = null;
                String name = null;
                email = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("mail.helpdesk");
                name = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("mail.helpdesk.name");
                if (email == null) {
                    email = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("mail.admin");
                    name = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("mail.admin.name");
                }
                author = new RequestItemAuthor(name, email);
            }
        }
        return author;
    }

    public void setEmailMetadata(String emailMetadata) {
        this.emailMetadata = emailMetadata;
    }

    public void setFullNameMetadata(String fullNameMetadata) {
        this.fullNameMetadata = fullNameMetadata;
    }
}

