/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static Logger log = LogManager.getLogger(XMLUtils.class);

    private XMLUtils() {
    }

    public static String getTextContent(Node xml, String singleNodeXPath) throws XPathExpressionException {
        String text = null;
        Node node = XMLUtils.getNode(xml, singleNodeXPath);
        if (node != null) {
            text = node.getTextContent();
        }
        return text;
    }

    public static Node getNode(Node xml, String NodeListXPath) throws XPathExpressionException {
        Node result = null;
        try {
            result = XPathAPI.selectSingleNode((Node)xml, (String)NodeListXPath);
        }
        catch (TransformerException e) {
            log.error("Error", (Throwable)e);
        }
        return result;
    }

    public static NodeList getNodeList(Node xml, String NodeListXPath) throws XPathExpressionException {
        NodeList nodeList = null;
        try {
            nodeList = XPathAPI.selectNodeList((Node)xml, (String)NodeListXPath);
        }
        catch (TransformerException e) {
            log.error("Error", (Throwable)e);
        }
        return nodeList;
    }

    public static Iterator<Node> getNodeListIterator(Node xml, String NodeListXPath) throws XPathExpressionException {
        return XMLUtils.getNodeListIterator(XMLUtils.getNodeList(xml, NodeListXPath));
    }

    public static Iterator<Node> getNodeListIterator(final NodeList nodeList) {
        return new Iterator<Node>(){
            private Iterator<Node> nodeIterator;
            private Node lastNode;
            {
                ArrayList<Node> nodes = new ArrayList<Node>();
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
                        nodes.add(node);
                    }
                }
                this.nodeIterator = nodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public Node next() {
                this.lastNode = this.nodeIterator.next();
                return this.lastNode;
            }

            @Override
            public void remove() {
                this.nodeIterator.remove();
            }
        };
    }

    public static Document convertStreamToXML(InputStream is) {
        Document result = null;
        if (is != null) {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                result = builder.parse(is);
            }
            catch (ParserConfigurationException e) {
                log.error("Error", (Throwable)e);
            }
            catch (SAXException e) {
                log.error("Error", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error", (Throwable)e);
            }
        }
        return result;
    }
}

