/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.dao.WorkspaceItemDAO;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.event.Event;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkspaceItemServiceImpl
implements WorkspaceItemService {
    private static final Logger log = LogManager.getLogger(WorkspaceItemServiceImpl.class);
    @Autowired(required=true)
    protected WorkspaceItemDAO workspaceItemDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected WorkflowService workflowService;

    protected WorkspaceItemServiceImpl() {
    }

    @Override
    public WorkspaceItem find(Context context, int id) throws SQLException {
        WorkspaceItem workspaceItem = (WorkspaceItem)this.workspaceItemDAO.findByID(context, WorkspaceItem.class, id);
        if (workspaceItem == null) {
            if (log.isDebugEnabled()) {
                log.debug(LogHelper.getHeader(context, "find_workspace_item", "not_found,workspace_item_id=" + id));
            }
        } else if (log.isDebugEnabled()) {
            log.debug(LogHelper.getHeader(context, "find_workspace_item", "workspace_item_id=" + id));
        }
        return workspaceItem;
    }

    @Override
    public WorkspaceItem create(Context context, Collection collection, boolean template) throws AuthorizeException, SQLException {
        return this.create(context, collection, null, template);
    }

    @Override
    public WorkspaceItem create(Context context, Collection collection, UUID uuid, boolean template) throws AuthorizeException, SQLException {
        this.authorizeService.authorizeAction(context, collection, 3);
        WorkspaceItem workspaceItem = this.workspaceItemDAO.create(context, new WorkspaceItem());
        workspaceItem.setCollection(collection);
        Item item = uuid != null ? this.itemService.create(context, workspaceItem, uuid) : this.itemService.create(context, workspaceItem);
        item.setSubmitter(context.getCurrentUser());
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 1, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 3, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 4, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 2, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        Item templateItem = collection.getTemplateItem();
        Optional<MetadataValue> colEntityType = this.getDSpaceEntityType(collection);
        Optional<MetadataValue> templateItemEntityType = this.getDSpaceEntityType(templateItem);
        if (colEntityType.isPresent() && templateItemEntityType.isPresent() && !StringUtils.equals((CharSequence)colEntityType.get().getValue(), (CharSequence)templateItemEntityType.get().getValue())) {
            throw new IllegalStateException("The template item has entity type : (" + templateItemEntityType.get().getValue() + ") different than collection entity type : " + colEntityType.get().getValue());
        }
        if (colEntityType.isPresent() && templateItemEntityType.isEmpty()) {
            MetadataValue original = colEntityType.get();
            MetadataField metadataField = original.getMetadataField();
            MetadataSchema metadataSchema = metadataField.getMetadataSchema();
            this.itemService.addMetadata(context, item, metadataSchema.getName(), metadataField.getElement(), metadataField.getQualifier(), original.getLanguage(), original.getValue());
        }
        if (template && templateItem != null) {
            List<MetadataValue> md = this.itemService.getMetadata(templateItem, "*", "*", "*", "*");
            for (MetadataValue aMd : md) {
                MetadataField metadataField = aMd.getMetadataField();
                MetadataSchema metadataSchema = metadataField.getMetadataSchema();
                this.itemService.addMetadata(context, item, metadataSchema.getName(), metadataField.getElement(), metadataField.getQualifier(), aMd.getLanguage(), aMd.getValue());
            }
        }
        this.itemService.update(context, item);
        workspaceItem.setItem(item);
        log.info(LogHelper.getHeader(context, "create_workspace_item", "workspace_item_id=" + workspaceItem.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        context.addEvent(new Event(2, 2, item.getID(), null, this.itemService.getIdentifiers(context, item)));
        return workspaceItem;
    }

    private Optional<MetadataValue> getDSpaceEntityType(DSpaceObject dSpaceObject) {
        return Objects.nonNull(dSpaceObject) ? dSpaceObject.getMetadata().stream().filter(x -> x.getMetadataField().toString('.').equalsIgnoreCase("dspace.entity.type")).findFirst() : Optional.empty();
    }

    @Override
    public WorkspaceItem create(Context c, WorkflowItem workflowItem) throws SQLException, AuthorizeException {
        WorkspaceItem workspaceItem = this.workspaceItemDAO.create(c, new WorkspaceItem());
        workspaceItem.setItem(workflowItem.getItem());
        workspaceItem.setCollection(workflowItem.getCollection());
        this.update(c, workspaceItem);
        return workspaceItem;
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep) throws SQLException {
        return this.workspaceItemDAO.findByEPerson(context, ep);
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep, Integer limit, Integer offset) throws SQLException {
        return this.workspaceItemDAO.findByEPerson(context, ep, limit, offset);
    }

    @Override
    public List<WorkspaceItem> findByCollection(Context context, Collection collection) throws SQLException {
        return this.workspaceItemDAO.findByCollection(context, collection);
    }

    @Override
    public WorkspaceItem findByItem(Context context, Item item) throws SQLException {
        return this.workspaceItemDAO.findByItem(context, item);
    }

    @Override
    public List<WorkspaceItem> findAllSupervisedItems(Context context) throws SQLException {
        return this.workspaceItemDAO.findWithSupervisedGroup(context);
    }

    @Override
    public List<WorkspaceItem> findSupervisedItemsByEPerson(Context context, EPerson ePerson) throws SQLException {
        return this.workspaceItemDAO.findBySupervisedGroupMember(context, ePerson);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context) throws SQLException {
        return this.workspaceItemDAO.findAll(context);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        return this.workspaceItemDAO.findAll(context, limit, offset);
    }

    @Override
    public void update(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
        log.info(LogHelper.getHeader(context, "update_workspace_item", "workspace_item_id=" + workspaceItem.getID()));
        this.itemService.update(context, workspaceItem.getItem());
        this.workspaceItemDAO.save(context, workspaceItem);
    }

    @Override
    public void deleteAll(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException, IOException {
        Item item = workspaceItem.getItem();
        if (!(this.authorizeService.isAdmin(context) || item.getSubmitter() != null && context.getCurrentUser() != null && context.getCurrentUser().getID() == item.getSubmitter().getID())) {
            throw new AuthorizeException("Must be an administrator or the original submitter to delete a workspace item");
        }
        log.info(LogHelper.getHeader(context, "delete_workspace_item", "workspace_item_id=" + workspaceItem.getID() + "item_id=" + item.getID() + "collection_id=" + workspaceItem.getCollection().getID()));
        workspaceItem.getSupervisorGroups().clear();
        this.workspaceItemDAO.delete(context, workspaceItem);
        this.itemService.delete(context, item);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.workspaceItemDAO.countRows(context);
    }

    @Override
    public int countByEPerson(Context context, EPerson ep) throws SQLException {
        return this.workspaceItemDAO.countRows(context, ep);
    }

    @Override
    public List<Map.Entry<Integer, Long>> getStageReachedCounts(Context context) throws SQLException {
        return this.workspaceItemDAO.getStageReachedCounts(context);
    }

    @Override
    public void deleteWrapper(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
        Item item = workspaceItem.getItem();
        this.authorizeService.authorizeAction(context, item, 1);
        log.info(LogHelper.getHeader(context, "delete_workspace_item", "workspace_item_id=" + workspaceItem.getID() + "item_id=" + item.getID() + "collection_id=" + workspaceItem.getCollection().getID()));
        try {
            workspaceItem.getSupervisorGroups().clear();
        }
        catch (Exception e) {
            log.error("failed to clear supervisor group", (Throwable)e);
        }
        this.workspaceItemDAO.delete(context, workspaceItem);
    }

    @Override
    public void move(Context context, WorkspaceItem source, Collection fromCollection, Collection toCollection) throws DCInputsReaderException {
        source.setCollection(toCollection);
        ArrayList<MetadataValue> remove = new ArrayList<MetadataValue>();
        List<String> diff = Util.differenceInSubmissionFields(fromCollection, toCollection);
        for (String toRemove : diff) {
            for (MetadataValue value : source.getItem().getMetadata()) {
                if (!value.getMetadataField().toString('.').equals(toRemove)) continue;
                remove.add(value);
            }
        }
        source.getItem().removeMetadata(remove);
    }
}

