/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public enum IndexClientOptions {
    REMOVE,
    CLEAN,
    FORCECLEAN,
    BUILD,
    BUILDANDSPELLCHECK,
    OPTIMIZE,
    SPELLCHECK,
    INDEX,
    UPDATE,
    FORCEUPDATE,
    UPDATEANDSPELLCHECK,
    FORCEUPDATEANDSPELLCHECK,
    HELP;


    protected static IndexClientOptions getIndexClientOption(CommandLine commandLine) {
        if (commandLine.hasOption("h")) {
            return HELP;
        }
        if (commandLine.hasOption("r")) {
            return REMOVE;
        }
        if (commandLine.hasOption("c")) {
            if (commandLine.hasOption("f")) {
                return FORCECLEAN;
            }
            return CLEAN;
        }
        if (commandLine.hasOption("b")) {
            if (commandLine.hasOption("s")) {
                return BUILDANDSPELLCHECK;
            }
            return BUILD;
        }
        if (commandLine.hasOption("o")) {
            return OPTIMIZE;
        }
        if (commandLine.hasOption("s")) {
            return SPELLCHECK;
        }
        if (commandLine.hasOption("i")) {
            return INDEX;
        }
        if (commandLine.hasOption("f") && commandLine.hasOption("s")) {
            return FORCEUPDATEANDSPELLCHECK;
        }
        if (commandLine.hasOption("f")) {
            return FORCEUPDATE;
        }
        if (commandLine.hasOption("s")) {
            return UPDATEANDSPELLCHECK;
        }
        return UPDATE;
    }

    protected static Options constructOptions() {
        Options options = new Options();
        options.addOption("r", "remove", true, "remove an Item, Collection or Community from index based on its handle");
        options.getOption("r").setType(String.class);
        options.addOption("i", "index", true, "add or update an Item, Collection or Community based on its handle or uuid");
        options.getOption("i").setType(Boolean.TYPE);
        options.addOption("c", "clean", false, "clean existing index removing any documents that no longer exist in the db");
        options.getOption("c").setType(Boolean.TYPE);
        options.addOption("b", "build", false, "(re)build index, wiping out current one if it exists");
        options.getOption("b").setType(Boolean.TYPE);
        options.addOption("s", "spellchecker", false, "Rebuild the spellchecker, can be combined with -b and -f.");
        options.getOption("s").setType(Boolean.TYPE);
        options.addOption("f", "force", false, "if updating existing index, force each handle to be reindexed even if uptodate");
        options.getOption("f").setType(Boolean.TYPE);
        options.addOption("h", "help", false, "print this help message");
        options.getOption("h").setType(Boolean.TYPE);
        return options;
    }
}

