/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.indexobject.IndexableDSpaceObject;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DiscoveryConfigurationService {
    private Map<String, DiscoveryConfiguration> map;
    private Map<Integer, List<String>> toIgnoreMetadataFields = new HashMap<Integer, List<String>>();

    public Map<String, DiscoveryConfiguration> getMap() {
        return this.map;
    }

    public void setMap(Map<String, DiscoveryConfiguration> map) {
        this.map = map;
    }

    public Map<Integer, List<String>> getToIgnoreMetadataFields() {
        return this.toIgnoreMetadataFields;
    }

    public void setToIgnoreMetadataFields(Map<Integer, List<String>> toIgnoreMetadataFields) {
        this.toIgnoreMetadataFields = toIgnoreMetadataFields;
    }

    public DiscoveryConfiguration getDiscoveryConfiguration(IndexableObject dso) {
        String name = dso == null ? "default" : (dso instanceof IndexableDSpaceObject ? ((DSpaceObject)((IndexableDSpaceObject)dso).getIndexedObject()).getHandle() : dso.getUniqueIndexID());
        return this.getDiscoveryConfiguration(name);
    }

    public DiscoveryConfiguration getDiscoveryConfiguration(String name) {
        DiscoveryConfiguration result;
        DiscoveryConfiguration discoveryConfiguration = result = StringUtils.isBlank((CharSequence)name) ? null : this.getMap().get(name);
        if (result == null) {
            result = this.getMap().get("default");
        }
        return result;
    }

    public DiscoveryConfiguration getDiscoveryConfigurationByNameOrDso(String configurationName, IndexableObject dso) {
        if (StringUtils.isNotBlank((CharSequence)configurationName) && this.getMap().containsKey(configurationName)) {
            return this.getMap().get(configurationName);
        }
        return this.getDiscoveryConfiguration(dso);
    }

    public List<DiscoveryConfiguration> getIndexAlwaysConfigurations() {
        ArrayList<DiscoveryConfiguration> configs = new ArrayList<DiscoveryConfiguration>();
        for (String key : this.map.keySet()) {
            DiscoveryConfiguration config = this.map.get(key);
            if (!config.isIndexAlways()) continue;
            configs.add(config);
        }
        return configs;
    }

    public static void main(String[] args) {
        System.out.println(DSpaceServicesFactory.getInstance().getServiceManager().getServicesNames().size());
        DiscoveryConfigurationService mainService = (DiscoveryConfigurationService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(DiscoveryConfigurationService.class.getName(), DiscoveryConfigurationService.class);
        for (String key : mainService.getMap().keySet()) {
            System.out.println(key);
            System.out.println("Facets:");
            DiscoveryConfiguration discoveryConfiguration = mainService.getMap().get(key);
            for (int i = 0; i < discoveryConfiguration.getSidebarFacets().size(); ++i) {
                DiscoverySearchFilterFacet sidebarFacet = discoveryConfiguration.getSidebarFacets().get(i);
                System.out.println("\t" + sidebarFacet.getIndexFieldName());
                for (int j = 0; j < sidebarFacet.getMetadataFields().size(); ++j) {
                    String metadataField = sidebarFacet.getMetadataFields().get(j);
                    System.out.println("\t\t" + metadataField);
                }
            }
            System.out.println("Search filters");
            List<DiscoverySearchFilter> searchFilters = discoveryConfiguration.getSearchFilters();
            for (DiscoverySearchFilter searchFilter : searchFilters) {
                for (int i = 0; i < searchFilter.getMetadataFields().size(); ++i) {
                    String metadataField = searchFilter.getMetadataFields().get(i);
                    System.out.println("\t\t" + metadataField);
                }
            }
            System.out.println("Recent submissions configuration:");
            DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration();
            System.out.println("\tMetadata sort field: " + recentSubmissionConfiguration.getMetadataSortField());
            System.out.println("\tMax recent submissions: " + recentSubmissionConfiguration.getMax());
            List<String> defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
            if (0 >= defaultFilterQueries.size()) continue;
            System.out.println("Default filter queries");
            for (String fq : defaultFilterQueries) {
                System.out.println("\t" + fq);
            }
        }
    }
}

