/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Collection;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.Subscription_;
import org.dspace.eperson.dao.SubscriptionDAO;

public class SubscriptionDAOImpl
extends AbstractHibernateDAO<Subscription>
implements SubscriptionDAO {
    protected SubscriptionDAOImpl() {
    }

    @Override
    public List<Subscription> findByEPerson(Context context, EPerson eperson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)subscriptionRoot.get(Subscription_.ePerson), (Object)eperson));
        return this.list(context, criteriaQuery, false, Subscription.class, -1, -1);
    }

    @Override
    public Subscription findByCollectionAndEPerson(Context context, EPerson eperson, Collection collection) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)subscriptionRoot.get(Subscription_.ePerson), (Object)eperson), (Expression)criteriaBuilder.equal((Expression)subscriptionRoot.get(Subscription_.collection), (Object)collection)));
        return (Subscription)this.singleResult(context, criteriaQuery);
    }

    @Override
    public void deleteByCollection(Context context, Collection collection) throws SQLException {
        String hqlQuery = "delete from Subscription where collection=:collection";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("collection", (Object)collection);
        query.executeUpdate();
    }

    @Override
    public void deleteByEPerson(Context context, EPerson eperson) throws SQLException {
        String hqlQuery = "delete from Subscription where ePerson=:ePerson";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("ePerson", (Object)eperson);
        query.executeUpdate();
    }

    @Override
    public void deleteByCollectionAndEPerson(Context context, Collection collection, EPerson eperson) throws SQLException {
        String hqlQuery = "delete from Subscription where collection=:collection AND ePerson=:ePerson";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("collection", (Object)collection);
        query.setParameter("ePerson", (Object)eperson);
        query.executeUpdate();
    }

    @Override
    public List<Subscription> findAllOrderedByEPerson(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        ArrayList<Order> orderList = new ArrayList<Order>(1);
        orderList.add(criteriaBuilder.asc((Expression)subscriptionRoot.get(Subscription_.ePerson)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Subscription.class, -1, -1);
    }
}

