/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public class Workflow
implements BeanNameAware {
    private String id;
    private Step firstStep;
    private List<Step> steps;

    public Step getFirstStep() {
        return this.firstStep;
    }

    public String getID() {
        return this.id;
    }

    public Step getStep(String stepID) throws WorkflowConfigurationException {
        for (Step step : this.steps) {
            if (!step.getId().equals(stepID)) continue;
            return step;
        }
        throw new WorkflowConfigurationException("Step definition not found for: " + stepID);
    }

    public Step getNextStep(Context context, XmlWorkflowItem wfi, Step currentStep, int outcome) throws WorkflowConfigurationException, SQLException {
        Step nextStep = currentStep.getNextStep(outcome);
        if (nextStep != null) {
            if (nextStep.isValidStep(context, wfi)) {
                return nextStep;
            }
            return this.getNextStep(context, wfi, nextStep, 0);
        }
        return null;
    }

    @Autowired(required=true)
    public void setFirstStep(Step firstStep) {
        firstStep.setWorkflow(this);
        this.firstStep = firstStep;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    @Autowired(required=true)
    public void setSteps(List<Step> steps) {
        for (Step step : steps) {
            step.setWorkflow(this);
        }
        this.steps = steps;
    }

    public Map<String, Role> getRoles() {
        HashMap<String, Role> roles = new HashMap<String, Role>();
        for (Step step : this.steps) {
            if (step.getRole() == null) continue;
            roles.put(step.getRole().getId(), step.getRole());
        }
        return roles;
    }

    public void setBeanName(String s) {
        this.id = s;
    }
}

