/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class PDFFilter
extends MediaFilter {
    private static Logger log = LogManager.getLogger(PDFFilter.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    @Override
    public String getBundleName() {
        return "TEXT";
    }

    @Override
    public String getFormatString() {
        return "Text";
    }

    @Override
    public String getDescription() {
        return "Extracted text";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        try {
            boolean useTemporaryFile = configurationService.getBooleanProperty("pdffilter.largepdfs", false);
            PDFTextStripper pts = new PDFTextStripper();
            pts.setSortByPosition(true);
            PDDocument pdfDoc = null;
            OutputStreamWriter writer = null;
            File tempTextFile = null;
            ByteArrayOutputStream byteStream = null;
            if (useTemporaryFile) {
                tempTextFile = File.createTempFile("dspacepdfextract" + source.hashCode(), ".txt");
                tempTextFile.deleteOnExit();
                writer = new OutputStreamWriter(new FileOutputStream(tempTextFile));
            } else {
                byteStream = new ByteArrayOutputStream();
                writer = new OutputStreamWriter(byteStream);
            }
            try {
                pdfDoc = PDDocument.load((InputStream)source);
                pts.writeText(pdfDoc, (Writer)writer);
            }
            catch (InvalidPasswordException ex) {
                log.error("PDF is encrypted. Cannot extract text (item: {})", new Supplier[]{() -> currentItem.getHandle()});
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                try {
                    if (pdfDoc != null) {
                        pdfDoc.close();
                    }
                }
                catch (Exception e) {
                    log.error("Error closing PDF file: " + e.getMessage(), (Throwable)e);
                }
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    log.error("Error closing temporary extract file: " + e.getMessage(), (Throwable)e);
                }
            }
            if (useTemporaryFile) {
                return new FileInputStream(tempTextFile);
            }
            byte[] bytes = byteStream.toByteArray();
            return new ByteArrayInputStream(bytes);
        }
        catch (OutOfMemoryError oome) {
            log.error("Error parsing PDF document " + oome.getMessage(), (Throwable)oome);
            if (configurationService.getBooleanProperty("pdffilter.skiponmemoryexception", false)) return null;
            throw oome;
        }
    }
}

